/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.common.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.common.data.manipulator.SpongeDataManipulator;
import org.spongepowered.common.util.CopyHelper;
import org.spongepowered.common.util.DataUtil;

final class MutableDataManipulator
extends SpongeDataManipulator
implements DataManipulator.Mutable {
    MutableDataManipulator() {
        super(new HashMap());
    }

    MutableDataManipulator(Map<Key<?>, Object> values) {
        super(values);
    }

    @Override
    public DataManipulator.Mutable asMutableCopy() {
        return this.copy();
    }

    @Override
    public DataManipulator.Immutable asImmutable() {
        return new ImmutableDataManipulator(Collections.unmodifiableMap(this.copyMap()));
    }

    @Override
    public DataManipulator.Mutable copyFrom(ValueContainer valueContainer, MergeFunction overlap, Predicate<Key<?>> predicate) {
        Preconditions.checkNotNull((Object)valueContainer, (Object)"valueContainer");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        Preconditions.checkNotNull((Object)overlap, (Object)"overlap");
        if (valueContainer instanceof SpongeDataManipulator) {
            SpongeDataManipulator manipulator = (SpongeDataManipulator)valueContainer;
            for (Map.Entry<Key<?>, Object> entry : manipulator.values.entrySet()) {
                if (!predicate.test(entry.getKey())) continue;
                if (overlap == MergeFunction.REPLACEMENT_PREFERRED) {
                    this.values.put(entry.getKey(), CopyHelper.copy(entry.getValue()));
                    continue;
                }
                @Nullable V original = this.values.get(entry.getKey());
                if (overlap == MergeFunction.ORIGINAL_PREFERRED && original != null) continue;
                Object merged = DataUtil.merge(overlap, entry.getKey(), original, entry.getValue());
                this.values.put(entry.getKey(), CopyHelper.copy(merged));
            }
        } else {
            for (Key<?> key : valueContainer.getKeys()) {
                if (!predicate.test(key)) continue;
                if (overlap == MergeFunction.REPLACEMENT_PREFERRED) {
                    this.values.put(key, CopyHelper.copy(valueContainer.require(key)));
                    continue;
                }
                @Nullable V original = this.values.get(key);
                if (overlap == MergeFunction.ORIGINAL_PREFERRED && original != null) continue;
                Object merged = DataUtil.merge(overlap, key, original, valueContainer.require(key));
                this.values.put(key, CopyHelper.copy(merged));
            }
        }
        return this;
    }

    @Override
    public DataManipulator.Mutable copyFrom(ValueContainer valueContainer, MergeFunction overlap, Iterable<Key<?>> keys) {
        Preconditions.checkNotNull((Object)valueContainer, (Object)"valueContainer");
        Preconditions.checkNotNull((Object)overlap, (Object)"overlap");
        Preconditions.checkNotNull(keys, (Object)"keys");
        if (valueContainer instanceof SpongeDataManipulator) {
            SpongeDataManipulator manipulator = (SpongeDataManipulator)valueContainer;
            MutableDataManipulator.copyFrom(this.values, overlap, keys, manipulator.values::get);
        } else {
            MutableDataManipulator.copyFrom(this.values, overlap, keys, key -> valueContainer.get(key).orElse(null));
        }
        return this;
    }

    @Override
    public DataManipulator.Mutable copyFrom(ValueContainer valueContainer, MergeFunction overlap) {
        Preconditions.checkNotNull((Object)valueContainer, (Object)"valueContainer");
        Preconditions.checkNotNull((Object)overlap, (Object)"overlap");
        MutableDataManipulator.copyFrom(this.values, valueContainer, overlap);
        return this;
    }

    public static void copyFrom(Map<Key<?>, Object> values, ValueContainer valueContainer, MergeFunction overlap) {
        if (valueContainer instanceof SpongeDataManipulator) {
            SpongeDataManipulator manipulator = (SpongeDataManipulator)valueContainer;
            MutableDataManipulator.copyFrom(values, overlap, manipulator.values.keySet(), manipulator.values::get);
        } else {
            MutableDataManipulator.copyFrom(values, overlap, valueContainer.getKeys(), key -> valueContainer.get(key).orElse(null));
        }
    }

    private static void copyFrom(Map<Key<?>, Object> values, MergeFunction overlap, Iterable<Key<?>> keys, Function<Key<?>, @Nullable Object> function) {
        for (Key<?> key : keys) {
            @Nullable Object replacement = function.apply(key);
            if (overlap == MergeFunction.REPLACEMENT_PREFERRED && replacement != null) {
                values.put(key, CopyHelper.copy(replacement));
                continue;
            }
            @Nullable Object original = values.get(key);
            if (overlap == MergeFunction.ORIGINAL_PREFERRED && original != null) continue;
            Object merged = DataUtil.merge(overlap, key, original, replacement);
            values.put(key, CopyHelper.copy(merged));
        }
    }

    @Override
    public <E> DataManipulator.Mutable set(Key<? extends Value<E>> key, E value) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(value, (Object)"value");
        this.values.put(key, CopyHelper.copy(value));
        return this;
    }

    @Override
    public DataManipulator.Mutable remove(Key<?> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        this.values.remove(key);
        return this;
    }

    @Override
    public DataManipulator.Mutable copy() {
        return new MutableDataManipulator(this.copyMap());
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.copyOf(this.values.keySet());
    }
}

