/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.provider.AbstractDataProvider;
import org.spongepowered.common.data.provider.MutableDataProvider;
import org.spongepowered.common.util.TypeTokenUtil;

public abstract class GenericMutableDataProviderBase<H, V extends Value<E>, E>
extends MutableDataProvider<V, E>
implements AbstractDataProvider.KnownHolderType {
    private final Class<H> holderType;

    protected GenericMutableDataProviderBase(Supplier<? extends Key<V>> key, Class<H> holderType) {
        this(key.get(), holderType);
    }

    protected GenericMutableDataProviderBase(Key<V> key, Class<H> holderType) {
        super(key);
        this.holderType = holderType;
    }

    protected GenericMutableDataProviderBase(Supplier<? extends Key<V>> key) {
        this(key.get());
    }

    protected GenericMutableDataProviderBase(Key<V> key) {
        super(key);
        this.holderType = GenericTypeReflector.erase(TypeTokenUtil.typeArgumentFromSupertype(this.getClass(), GenericMutableDataProviderBase.class, 0));
    }

    private boolean isTypeAllowed(DataHolder dataHolder) {
        return this.holderType.isInstance(dataHolder);
    }

    public Class<H> getHolderType() {
        return this.holderType;
    }

    protected boolean supports(H dataHolder) {
        return true;
    }

    protected abstract Optional<E> getFrom(H var1);

    public Optional<V> getValueFrom(H dataHolder) {
        return this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e));
    }

    protected boolean set(H dataHolder, E value) {
        return false;
    }

    protected DataTransactionResult setAndGetResult(H dataHolder, E value) {
        Optional<Value.Immutable> originalValue = this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e).asImmutable());
        Value.Immutable<E> replacementValue = Value.immutableOf(this.key(), value);
        try {
            if (this.set(dataHolder, value)) {
                DataTransactionResult.Builder builder = DataTransactionResult.builder();
                originalValue.ifPresent(builder::replace);
                return builder.result(DataTransactionResult.Type.SUCCESS).success(replacementValue).build();
            }
            return DataTransactionResult.failResult(replacementValue);
        }
        catch (Exception e2) {
            SpongeCommon.logger().debug("An exception occurred when setting data: ", (Throwable)e2);
            return DataTransactionResult.errorResult(replacementValue);
        }
    }

    protected V constructValue(H dataHolder, E element) {
        return Value.genericImmutableOf(this.key(), element);
    }

    protected boolean delete(H dataHolder) {
        return false;
    }

    protected DataTransactionResult deleteAndGetResult(H dataHolder) {
        Optional<Value.Immutable> originalValue = this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e).asImmutable());
        if (!originalValue.isPresent()) {
            return DataTransactionResult.failNoData();
        }
        if (this.delete(dataHolder)) {
            return DataTransactionResult.successRemove(originalValue.get());
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public final boolean isSupported(DataHolder dataHolder) {
        return this.isTypeAllowed(dataHolder) && this.supports(dataHolder);
    }

    @Override
    public boolean isSupported(Type dataHolder) {
        return this.holderType.isAssignableFrom(GenericTypeReflector.erase(dataHolder));
    }

    @Override
    public final Optional<V> value(DataHolder dataHolder) {
        if (!this.isSupported(dataHolder)) {
            return Optional.empty();
        }
        return this.getValueFrom(dataHolder);
    }

    @Override
    public final Optional<E> get(DataHolder dataHolder) {
        if (!this.isSupported(dataHolder)) {
            return Optional.empty();
        }
        return this.getFrom(dataHolder);
    }

    @Override
    public final DataTransactionResult offerValue(DataHolder.Mutable dataHolder, V value) {
        if (!this.isSupported(dataHolder)) {
            return DataTransactionResult.failNoData();
        }
        Optional<Value.Immutable> originalValue = this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e).asImmutable());
        Value.Immutable replacementValue = value.asImmutable();
        try {
            if (this.set(dataHolder, value.get())) {
                DataTransactionResult.Builder builder = DataTransactionResult.builder();
                originalValue.ifPresent(builder::replace);
                return builder.result(DataTransactionResult.Type.SUCCESS).success(replacementValue).build();
            }
            return DataTransactionResult.failResult(replacementValue);
        }
        catch (Exception e2) {
            SpongeCommon.logger().debug("An exception occurred when setting data: ", (Throwable)e2);
            return DataTransactionResult.errorResult(replacementValue);
        }
    }

    @Override
    public final DataTransactionResult offer(DataHolder.Mutable dataHolder, E element) {
        if (!this.isSupported(dataHolder)) {
            return DataTransactionResult.failResult(Value.immutableOf(this.key(), element));
        }
        return this.setAndGetResult(dataHolder, element);
    }

    @Override
    public final DataTransactionResult remove(DataHolder.Mutable dataHolder) {
        if (!this.isSupported(dataHolder)) {
            return DataTransactionResult.failNoData();
        }
        return this.deleteAndGetResult(dataHolder);
    }
}

