/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.state;

import java.util.HashMap;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.accessor.world.level.block.AbstractSkullBlockAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.StateUtil;

public final class WallSkullBlockData {
    private WallSkullBlockData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)registrator.asImmutable(BlockState.class).create(Keys.DIRECTION).get(h -> Constants.DirectionFunctions.getFor((Direction)h.getValue((Property)WallSkullBlock.FACING)))).set((h, v) -> (BlockState)h.setValue((Property)WallSkullBlock.FACING, (Comparable)Constants.DirectionFunctions.getFor(v)))).supports(h -> h.getBlock() instanceof WallSkullBlock)).create(Keys.IS_ATTACHED).get(h -> h.getBlock() instanceof WallSkullBlock)).set((h, v) -> {
            HashMap<SkullBlock.Type, Pair> wallAndGroundPairs = new HashMap<SkullBlock.Type, Pair>();
            AbstractSkullBlock block = (AbstractSkullBlock)h.getBlock();
            boolean isWallBlock = block instanceof WallSkullBlock;
            if (v == isWallBlock) {
                return h;
            }
            SkullBlock.Type type = ((AbstractSkullBlockAccessor)block).accessor$type();
            Pair pair = wallAndGroundPairs.computeIfAbsent(type, type1 -> {
                SkullBlock groundBlock = Registry.BLOCK.stream().filter(b -> b instanceof SkullBlock && ((AbstractSkullBlockAccessor)b).accessor$type() == type).findFirst().orElse(null);
                if (groundBlock == null) {
                    return null;
                }
                WallSkullBlock wallBlock = Registry.BLOCK.stream().filter(b -> b instanceof WallSkullBlock && ((AbstractSkullBlockAccessor)b).accessor$type() == type).findFirst().orElse(null);
                if (wallBlock == null) {
                    return null;
                }
                return new Pair(groundBlock, wallBlock);
            });
            if (pair == null) {
                return h;
            }
            WallSkullBlock newType = v != false ? pair.wallBlock : pair.groundBlock;
            return StateUtil.copyStatesFrom(newType.defaultBlockState(), h);
        })).supports(h -> h.getBlock() instanceof WallSkullBlock);
    }

    private static final class Pair {
        final SkullBlock groundBlock;
        final WallSkullBlock wallBlock;

        private Pair(SkullBlock groundBlock, WallSkullBlock wallBlock) {
            this.groundBlock = groundBlock;
            this.wallBlock = wallBlock;
        }
    }
}

