/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.VecHelper;

final class CompassItemData {
    private CompassItemData() {
    }

    static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.LODESTONE).get(stack -> {
            CompoundTag tag;
            Optional dimension;
            if (CompassItem.isLodestoneCompass((ItemStack)stack) && (dimension = CompassItem.getLodestoneDimension((CompoundTag)(tag = stack.getOrCreateTag()))).isPresent()) {
                return ServerLocation.of((ServerWorld)SpongeCommon.server().getLevel((ResourceKey)dimension.get()), VecHelper.toVector3d(NbtUtils.readBlockPos((CompoundTag)tag.getCompound("LodestonePos"))));
            }
            return null;
        })).set((stack, location) -> {
            CompoundTag tag = stack.getOrCreateTag();
            tag.put("LodestonePos", (Tag)NbtUtils.writeBlockPos((BlockPos)VecHelper.toBlockPos(location)));
            Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((ServerLevel)location.world()).dimension()).resultOrPartial(arg_0 -> ((Logger)SpongeCommon.logger()).error(arg_0)).ifPresent(dimension -> tag.put("LodestoneDimension", dimension));
            tag.putBoolean("LodestoneTracked", true);
        })).delete(stack -> {
            CompoundTag tag = stack.getTag();
            if (tag != null) {
                tag.remove("LodestoneDimension");
                tag.remove("LodestonePos");
                tag.remove("LodestoneTracked");
            }
        });
    }
}

