/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.potion;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.util.Constants;

public final class SpongePotionBuilder
extends AbstractDataBuilder<PotionEffect>
implements PotionEffect.Builder {
    private @Nullable PotionEffectType potionType;
    private Ticks duration = Ticks.zero();
    private int amplifier;
    private boolean isAmbient;
    private boolean showParticles;
    private boolean showIcon;

    public SpongePotionBuilder() {
        super(PotionEffect.class, 2);
        this.reset();
    }

    @Override
    public PotionEffect.Builder from(PotionEffect holder) {
        this.potionType = ((PotionEffect)Preconditions.checkNotNull((Object)holder)).type();
        this.duration = holder.duration();
        this.amplifier = holder.amplifier();
        this.isAmbient = holder.isAmbient();
        this.showParticles = holder.showsParticles();
        this.showIcon = holder.showsIcon();
        return this;
    }

    @Override
    protected Optional<PotionEffect> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!(container.contains(Constants.Item.Potions.POTION_TYPE) && container.contains(Constants.Item.Potions.POTION_DURATION) && container.contains(Constants.Item.Potions.POTION_AMPLIFIER) && container.contains(Constants.Item.Potions.POTION_AMBIANCE) && container.contains(Constants.Item.Potions.POTION_SHOWS_PARTICLES))) {
            return Optional.empty();
        }
        String effectName = container.getString(Constants.Item.Potions.POTION_TYPE).get();
        Optional optional = Sponge.game().registry(RegistryTypes.POTION_EFFECT_TYPE).findValue(ResourceKey.resolve(effectName));
        if (!optional.isPresent()) {
            throw new InvalidDataException("The container has an invalid potion type name: " + effectName);
        }
        Ticks duration = Ticks.of(container.getInt(Constants.Item.Potions.POTION_DURATION).get().intValue());
        int amplifier = container.getInt(Constants.Item.Potions.POTION_AMPLIFIER).get();
        boolean ambience = container.getBoolean(Constants.Item.Potions.POTION_AMBIANCE).get();
        boolean particles = container.getBoolean(Constants.Item.Potions.POTION_SHOWS_PARTICLES).get();
        SpongePotionBuilder builder = new SpongePotionBuilder();
        return Optional.of(builder.potionType((PotionEffectType)optional.get()).showParticles(particles).duration(duration).amplifier(amplifier).ambient(ambience).build());
    }

    @Override
    public @NonNull PotionEffect.Builder potionType(@NonNull PotionEffectType potionEffectType) {
        Objects.requireNonNull(potionEffectType, "Potion effect type cannot be null");
        this.potionType = potionEffectType;
        return this;
    }

    @Override
    public PotionEffect.Builder duration(@NonNull Ticks duration) {
        if (duration.ticks() <= 0L) {
            throw new IllegalArgumentException("Duration must be positive");
        }
        this.duration = duration;
        return this;
    }

    @Override
    public PotionEffect.Builder amplifier(int amplifier) throws IllegalArgumentException {
        if (amplifier < 0) {
            throw new IllegalArgumentException("Amplifier must not be negative");
        }
        this.amplifier = amplifier;
        return this;
    }

    @Override
    public PotionEffect.Builder ambient(boolean ambience) {
        this.isAmbient = ambience;
        return this;
    }

    @Override
    public PotionEffect.Builder showParticles(boolean showParticles) {
        this.showParticles = showParticles;
        return this;
    }

    @Override
    public PotionEffect.Builder showIcon(boolean showIcon) {
        this.showIcon = showIcon;
        return this;
    }

    @Override
    public PotionEffect build() throws IllegalStateException {
        Preconditions.checkState((this.potionType != null ? 1 : 0) != 0, (Object)"Potion type has not been set");
        if (this.duration.ticks() <= 0L) {
            throw new IllegalStateException("Duration has not been set");
        }
        return (PotionEffect)new MobEffectInstance((MobEffect)this.potionType, (int)this.duration.ticks(), this.amplifier, this.isAmbient, this.showParticles, this.showIcon);
    }

    @Override
    public PotionEffect.Builder reset() {
        this.potionType = null;
        this.amplifier = 0;
        this.duration = Ticks.zero();
        this.isAmbient = true;
        this.showParticles = true;
        this.showIcon = true;
        return this;
    }
}

