/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.goal.builtin.creature.AvoidLivingGoal;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;

public final class SpongeAvoidLivingGoalBuilder
implements AvoidLivingGoal.Builder {
    private Predicate<Living> targetSelector;
    private float searchDistance;
    private double closeRangeSpeed;
    private double farRangeSpeed;

    public SpongeAvoidLivingGoalBuilder() {
        this.reset();
    }

    @Override
    public AvoidLivingGoal.Builder targetSelector(Predicate<Living> predicate) {
        this.targetSelector = predicate;
        return this;
    }

    @Override
    public AvoidLivingGoal.Builder searchDistance(float distance) {
        this.searchDistance = distance;
        return this;
    }

    @Override
    public AvoidLivingGoal.Builder closeRangeSpeed(double speed) {
        this.closeRangeSpeed = speed;
        return this;
    }

    @Override
    public AvoidLivingGoal.Builder farRangeSpeed(double speed) {
        this.farRangeSpeed = speed;
        return this;
    }

    @Override
    public AvoidLivingGoal.Builder from(AvoidLivingGoal value) {
        return this.targetSelector(value.targetSelector()).searchDistance(value.searchDistance()).closeRangeSpeed(value.closeRangeSpeed()).farRangeSpeed(value.farRangeSpeed());
    }

    @Override
    public AvoidLivingGoal.Builder reset() {
        this.targetSelector = null;
        this.searchDistance = 1.0f;
        this.closeRangeSpeed = 1.0;
        this.farRangeSpeed = 1.0;
        return this;
    }

    @Override
    public AvoidLivingGoal build(Creature owner) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull(this.targetSelector);
        return (AvoidLivingGoal)new AvoidEntityGoal((PathfinderMob)owner, Entity.class, this.searchDistance, this.closeRangeSpeed, this.farRangeSpeed, this.targetSelector);
    }
}

