/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.world.level.GameType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class SpongeTabList
implements TabList {
    private static final Component EMPTY_COMPONENT = new TextComponent("");
    private final net.minecraft.server.level.ServerPlayer player;
    private @Nullable net.kyori.adventure.text.Component header;
    private @Nullable net.kyori.adventure.text.Component footer;
    private final Map<UUID, TabListEntry> entries = Maps.newHashMap();

    public SpongeTabList(net.minecraft.server.level.ServerPlayer player) {
        this.player = player;
    }

    @Override
    public ServerPlayer player() {
        return (ServerPlayer)this.player;
    }

    @Override
    public Optional<net.kyori.adventure.text.Component> header() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public TabList setHeader(@Nullable net.kyori.adventure.text.Component header) {
        this.header = header;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public Optional<net.kyori.adventure.text.Component> footer() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public TabList setFooter(@Nullable net.kyori.adventure.text.Component footer) {
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public TabList setHeaderAndFooter(@Nullable net.kyori.adventure.text.Component header, @Nullable net.kyori.adventure.text.Component footer) {
        this.header = header;
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    private void refreshClientHeaderFooter() {
        ClientboundTabListPacket packet = new ClientboundTabListPacket(this.header == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.header), this.footer == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.footer));
        this.player.connection.send((Packet)packet);
    }

    @Override
    public Collection<TabListEntry> entries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Override
    public Optional<TabListEntry> entry(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        return Optional.ofNullable(this.entries.get(uniqueId));
    }

    @Override
    public TabList addEntry(TabListEntry entry) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)entry, (Object)"builder");
        Preconditions.checkState((boolean)entry.list().equals(this), (Object)"the provided tab list entry was not created for this tab list");
        this.addEntry(entry, true);
        return this;
    }

    private void addEntry(ClientboundPlayerInfoPacket.PlayerUpdate entry) {
        GameProfile profile = entry.getProfile();
        if (!this.entries.containsKey(profile.getId())) {
            Component displayName = entry.getDisplayName();
            this.addEntry(new SpongeTabListEntry(this, SpongeGameProfile.of(profile), displayName == null ? null : SpongeAdventure.asAdventure(displayName), entry.getLatency(), (GameMode)entry.getGameMode()), false);
        }
    }

    private void addEntry(TabListEntry entry, boolean exceptionOnDuplicate) {
        UUID uniqueId = entry.profile().uniqueId();
        if (exceptionOnDuplicate) {
            Preconditions.checkArgument((!this.entries.containsKey(uniqueId) ? 1 : 0) != 0, (Object)"cannot add duplicate entry");
        }
        if (!this.entries.containsKey(uniqueId)) {
            this.entries.put(uniqueId, entry);
            this.sendUpdate(entry, ClientboundPlayerInfoPacket.Action.ADD_PLAYER);
            entry.displayName().ifPresent(text -> this.sendUpdate(entry, ClientboundPlayerInfoPacket.Action.UPDATE_DISPLAY_NAME));
            this.sendUpdate(entry, ClientboundPlayerInfoPacket.Action.UPDATE_LATENCY);
            this.sendUpdate(entry, ClientboundPlayerInfoPacket.Action.UPDATE_GAME_MODE);
        }
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        TabListEntry entry = this.entries.remove(uniqueId);
        if (entry != null) {
            this.sendUpdate(entry, ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER);
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    void sendUpdate(TabListEntry entry, ClientboundPlayerInfoPacket.Action action) {
        ClientboundPlayerInfoPacket packet = new ClientboundPlayerInfoPacket(action, new ArrayList());
        ClientboundPlayerInfoPacket.PlayerUpdate data = new ClientboundPlayerInfoPacket.PlayerUpdate(SpongeGameProfile.toMcProfile(entry.profile()), entry.latency(), (GameType)entry.gameMode(), entry.displayName().isPresent() ? SpongeAdventure.asVanilla(entry.displayName().get()) : null);
        packet.getEntries().add(data);
        this.player.connection.send((Packet)packet);
    }

    public void updateEntriesOnSend(ClientboundPlayerInfoPacket packet) {
        for (ClientboundPlayerInfoPacket.PlayerUpdate update : packet.getEntries()) {
            ClientboundPlayerInfoPacket.Action action = packet.getAction();
            if (action == ClientboundPlayerInfoPacket.Action.ADD_PLAYER) {
                this.addEntry(update);
                continue;
            }
            if (action == ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER) {
                this.removeEntry(update.getProfile().getId());
                continue;
            }
            this.entry(update.getProfile().getId()).ifPresent(entry -> {
                if (action == ClientboundPlayerInfoPacket.Action.UPDATE_DISPLAY_NAME) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setDisplayName(update.getDisplayName() == null ? null : SpongeAdventure.asAdventure(update.getDisplayName()));
                } else if (action == ClientboundPlayerInfoPacket.Action.UPDATE_LATENCY) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setLatency(update.getLatency());
                } else if (action == ClientboundPlayerInfoPacket.Action.UPDATE_GAME_MODE) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setGameMode((GameMode)update.getGameMode());
                } else {
                    throw new IllegalArgumentException("unknown packet action: " + action);
                }
            });
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("player", (Object)this.player).add("header", (Object)this.header).add("footer", (Object)this.footer).add("entries", this.entries).toString();
    }
}

