/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class SetAndRegisterBlockEntityToLevelChunk
implements ProcessingSideEffect {
    public static SetAndRegisterBlockEntityToLevelChunk getInstance() {
        return Holder.INSTANCE;
    }

    SetAndRegisterBlockEntityToLevelChunk() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        ServerLevel serverWorld = pipeline.getServerWorld();
        @Nullable BlockEntity blockEntity = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        if (serverWorld.isOutsideBuildHeight(pos)) {
            return EffectResult.NULL_RETURN;
        }
        pipeline.getAffectedChunk().addAndRegisterBlockEntity(blockEntity);
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final SetAndRegisterBlockEntityToLevelChunk INSTANCE = new SetAndRegisterBlockEntityToLevelChunk();

        private Holder() {
        }
    }
}

