/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UpdateChunkLightManagerEffect
implements ProcessingSideEffect {
    private UpdateChunkLightManagerEffect() {
    }

    public static UpdateChunkLightManagerEffect getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        boolean isStillEmpty;
        LevelChunkSection chunkSection = pipeline.getAffectedSection();
        boolean wasEmpty = pipeline.wasEmpty();
        if (wasEmpty != (isStillEmpty = chunkSection.isEmpty())) {
            pipeline.getServerWorld().getChunkSource().getLightEngine().updateSectionStatus(oldState.pos, isStillEmpty);
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final UpdateChunkLightManagerEffect INSTANCE = new UpdateChunkLightManagerEffect();

        private Holder() {
        }
    }
}

