/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UpdateConnectingBlocksEffect
implements ProcessingSideEffect {
    public static UpdateConnectingBlocksEffect getInstance() {
        return Holder.INSTANCE;
    }

    UpdateConnectingBlocksEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        ServerLevel world = pipeline.getServerWorld();
        BlockPos pos = oldState.pos;
        if (flag.updateNeighboringShapes() && limit > 0) {
            int withoutNeighborDropsAndNestedNeighborUpdates = flag.asNestedNeighborUpdates().getRawFlag();
            oldState.state.updateIndirectNeighbourShapes((LevelAccessor)world, pos, withoutNeighborDropsAndNestedNeighborUpdates, limit - 1);
            newState.updateNeighbourShapes((LevelAccessor)world, pos, withoutNeighborDropsAndNestedNeighborUpdates, limit - 1);
            newState.updateIndirectNeighbourShapes((LevelAccessor)world, pos, withoutNeighborDropsAndNestedNeighborUpdates, limit - 1);
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final UpdateConnectingBlocksEffect INSTANCE = new UpdateConnectingBlocksEffect();

        private Holder() {
        }
    }
}

