/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.inventory.InventoryBasedTransaction;

public class SetCarriedItemTransaction
extends InventoryBasedTransaction {
    private final ServerPlayer player;
    private final @Nullable Slot prevSlot;
    private final @Nullable Slot newSlot;
    private final int prevSlotId;

    public SetCarriedItemTransaction(Player player, int newSlot) {
        super((Inventory)player.getInventory());
        this.player = (ServerPlayer)player;
        PlayerInventory inventory = (PlayerInventory)this.player.getInventory();
        this.prevSlotId = this.player.getInventory().selected;
        this.prevSlot = inventory.hotbar().slot(this.prevSlotId).orElse(null);
        this.newSlot = inventory.hotbar().slot(newSlot).orElse(null);
    }

    @Override
    Optional<ChangeInventoryEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        if (!entities.isEmpty()) {
            SpongeCommon.logger().warn("Entities are being captured but not being processed");
        }
        if (this.newSlot == null || this.prevSlot == null) {
            return Optional.empty();
        }
        ChangeInventoryEvent.Held event = SpongeEventFactory.createChangeInventoryEventHeld(cause, this.newSlot, (Inventory)this.player.getInventory(), this.prevSlot, slotTransactions);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        this.player.connection.send((Packet)new ClientboundSetCarriedItemPacket(this.prevSlotId));
        this.player.getInventory().selected = this.prevSlotId;
        this.handleEventResults((Player)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        this.handleEventResults((Player)this.player, event);
    }
}

