/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.util.MemoizedSupplier;
import org.spongepowered.common.world.BlockChange;

abstract class LocationBasedTickPhaseState<T extends LocationBasedTickContext<T>>
extends TickPhaseState<T> {
    private final BiConsumer<CauseStackManager.StackFrame, T> LOCATION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(LocatableBlock.class).ifPresent(frame::pushCause));

    LocationBasedTickPhaseState() {
    }

    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, T> getFrameModifier() {
        return this.LOCATION_MODIFIER;
    }

    @Override
    public void unwind(T context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public void associateNeighborStateNotifier(T context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerLevel minecraftWorld, PlayerTracker.Type notifier) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            LevelChunkBridge mixinChunk = (LevelChunkBridge)minecraftWorld.getChunkAt(notifyPos);
            mixinChunk.bridge$addTrackedBlockPosition(block, notifyPos, (UUID)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public boolean doesBlockEventTracking(T context) {
        return ((PhaseContext)context).allowsBlockEvents();
    }

    @Override
    public void appendNotifierToBlockEvent(T context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
        LocatableBlock source = this.getLocatableBlockSourceFromContext((PhaseContext<?>)context);
        blockEvent.bridge$setTickingLocatable(source);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(T context) {
        return MemoizedSupplier.memoize(() -> {
            World<@NonNull ?, @NonNull ?> world = this.getLocatableBlockSourceFromContext((PhaseContext<?>)context).world();
            return (ResourceKey)((Level)world).dimension().location();
        });
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, T context) {
        ((PhaseContext)context).applyOwnerIfAvailable(explosionContext::creator);
        ((PhaseContext)context).applyNotifierIfAvailable(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext((PhaseContext<?>)context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public void postBlockTransactionApplication(T context, BlockChange blockChange, BlockTransactionReceipt receipt) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            SpongeBlockSnapshot original = (SpongeBlockSnapshot)receipt.originalBlock();
            Block block = (Block)original.state().type();
            BlockPos changedBlockPos = original.getBlockPos();
            original.getServerWorld().ifPresent(worldServer -> {
                LevelChunkBridge changedMixinChunk = (LevelChunkBridge)worldServer.getChunkAt(changedBlockPos);
                changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)user, PlayerTracker.Type.NOTIFIER);
                if (blockChange == BlockChange.PLACE) {
                    context.applyOwnerIfAvailable(owner -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)owner, PlayerTracker.Type.CREATOR));
                }
            });
        });
    }
}

