/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl;

import com.google.common.base.Preconditions;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.property.KeyValuePair;

public abstract class SlotBasedLens
extends AbstractLens {
    protected final int stride;

    public SlotBasedLens(int base, int size, int stride, Class<? extends Inventory> adapterType, SlotLensProvider slots) {
        super(base, size, adapterType);
        Preconditions.checkArgument((stride > 0 ? 1 : 0) != 0, (String)"Invalid stride: %s", (int)stride);
        this.stride = stride;
        this.init(slots);
    }

    private void init(SlotLensProvider slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addSpanningChild(slots.getSlotLens(slot), KeyValuePair.slotIndex(ord));
            ++ord;
            slot += this.stride;
        }
    }
}

