/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.util.Constants;

public class SpongeFireworkEffect
implements FireworkEffect {
    private final boolean flicker;
    private final boolean trails;
    private final ImmutableList<Color> colors;
    private final ImmutableList<Color> fades;
    private final FireworkShape shape;

    SpongeFireworkEffect(boolean flicker, boolean trails, Iterable<Color> colors, Iterable<Color> fades, FireworkShape shape) {
        this.flicker = flicker;
        this.trails = trails;
        this.colors = ImmutableList.copyOf(colors);
        this.fades = ImmutableList.copyOf(fades);
        this.shape = shape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeFireworkEffect that = (SpongeFireworkEffect)o;
        return this.flicker == that.flicker && this.trails == that.trails && Objects.equals(this.colors, that.colors) && Objects.equals(this.fades, that.fades) && Objects.equals(this.shape, that.shape);
    }

    public int hashCode() {
        return Objects.hash(this.flicker, this.trails, this.colors, this.fades, this.shape);
    }

    @Override
    public boolean flickers() {
        return this.flicker;
    }

    @Override
    public boolean hasTrail() {
        return this.trails;
    }

    @Override
    public List<Color> colors() {
        return this.colors;
    }

    @Override
    public List<Color> fadeColors() {
        return this.fades;
    }

    @Override
    public FireworkShape shape() {
        return this.shape;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.FIREWORK_SHAPE).valueKey(this.shape);
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Item.Fireworks.FIREWORK_SHAPE, resourceKey).set(Constants.Item.Fireworks.FIREWORK_COLORS, this.colors).set(Constants.Item.Fireworks.FIREWORK_FADE_COLORS, this.fades).set(Constants.Item.Fireworks.FIREWORK_TRAILS, this.trails).set(Constants.Item.Fireworks.FIREWORK_FLICKERS, this.flicker);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shape", (Object)this.shape).add("trails", this.trails).add("flickers", this.flicker).add("colors", this.colors).add("fades", this.fades).toString();
    }
}

