/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.custom;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.MissingImplementationException;

public final class SpongeSpecialRecipe
extends CustomRecipe {
    private final BiPredicate<CraftingGridInventory, ServerWorld> biPredicate;
    private final Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction;
    private final Function<CraftingGridInventory, ItemStack> resultFunction;

    public SpongeSpecialRecipe(ResourceLocation idIn, BiPredicate<CraftingGridInventory, ServerWorld> biPredicate, Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction, Function<CraftingGridInventory, ItemStack> resultFunction) {
        super(idIn);
        this.biPredicate = biPredicate;
        this.remainingItemsFunction = remainingItemsFunction;
        this.resultFunction = resultFunction;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.biPredicate.test(InventoryUtil.toSpongeInventory(inv), (ServerWorld)worldIn);
    }

    public net.minecraft.world.item.ItemStack assemble(CraftingContainer inv) {
        return ItemStackUtil.toNative(this.resultFunction.apply(InventoryUtil.toSpongeInventory(inv)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canCraftInDimensions(int width, int height) {
        throw new MissingImplementationException("SpongeSpecialRecipe", "canFit");
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(CraftingContainer inv) {
        if (this.remainingItemsFunction == null) {
            return super.getRemainingItems((Container)inv);
        }
        List<ItemStack> remainingSponge = this.remainingItemsFunction.apply(InventoryUtil.toSpongeInventory(inv));
        NonNullList remaining = NonNullList.create();
        remainingSponge.forEach(item -> remaining.add((Object)ItemStackUtil.toNative(item)));
        return remaining;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.BANNER_DUPLICATE;
    }
}

