/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.UpgradeRecipe;

public class SpongeSmithingRecipe
extends UpgradeRecipe {
    private final Function<Container, ItemStack> resultFunction;

    public SpongeSmithingRecipe(ResourceLocation idIn, Ingredient base, Ingredient addition, ItemStack resultIn, Function<Container, ItemStack> resultFunction) {
        super(idIn, base, addition, resultIn);
        this.resultFunction = resultFunction;
    }

    public ItemStack assemble(Container p_77572_1_) {
        if (this.resultFunction != null) {
            return this.resultFunction.apply(p_77572_1_);
        }
        if (this.getResultItem().hasTag()) {
            ItemStack itemStack = this.getResultItem().copy();
            CompoundTag compoundnbt = p_77572_1_.getItem(0).getTag();
            if (compoundnbt != null) {
                CompoundTag merged = itemStack.getTag().merge(compoundnbt.copy());
                itemStack.setTag(merged);
                return itemStack;
            }
        }
        return super.assemble(p_77572_1_);
    }

    public ItemStack getResultItem() {
        if (this.resultFunction != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem();
    }
}

