/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.color;

import java.util.Objects;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.map.color.MapColor;
import org.spongepowered.api.map.color.MapColorType;
import org.spongepowered.api.map.color.MapShade;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.map.color.SpongeMapColorType;
import org.spongepowered.common.map.color.SpongeMapShade;
import org.spongepowered.common.util.Constants;

public final class SpongeMapColor
implements MapColor {
    private final MapColorType type;
    private final MapShade shade;
    private final byte mcColor;

    public SpongeMapColor(MapColorType type, MapShade shade) {
        this.type = type;
        this.shade = shade;
        this.mcColor = (byte)(((SpongeMapColorType)this.type).getColorIndex() * 4 + ((SpongeMapShade)shade).getShadeNum());
    }

    public byte getMCColor() {
        return this.mcColor;
    }

    @Override
    public MapShade shade() {
        return this.shade;
    }

    @Override
    public MapColorType type() {
        return this.type;
    }

    @Override
    public Color color() {
        Color color = this.type().color();
        int r = this.addShade(color.red());
        int g = this.addShade(color.green());
        int b = this.addShade(color.blue());
        return Color.ofRgb(r, g, b);
    }

    private int addShade(int color) {
        return Math.floorDiv(color * ((SpongeMapShade)this.shade).getMultiplier(), 255);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Map.COLOR_INDEX, ((SpongeMapColorType)this.type).getColorIndex()).set(Constants.Map.SHADE_NUM, ((SpongeMapShade)this.shade).getShadeNum());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeMapColor that = (SpongeMapColor)o;
        return this.type.equals(that.type) && this.shade.equals(that.shade);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.shade);
    }
}

