/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.players;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.players.GameProfileCache;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.players.GameProfileCache_GameProfileInfoAccessor;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={GameProfileCache.class})
public abstract class GameProfileCacheMixin_API
implements org.spongepowered.api.profile.GameProfileCache {
    @Shadow
    @Final
    @Mutable
    private final Map<String, GameProfileCache_GameProfileInfoAccessor> profilesByName = new ConcurrentHashMap<String, GameProfileCache_GameProfileInfoAccessor>();
    @Shadow
    @Final
    @Mutable
    private final Map<UUID, GameProfileCache_GameProfileInfoAccessor> profilesByUUID = new ConcurrentHashMap<UUID, GameProfileCache_GameProfileInfoAccessor>();

    @Shadow
    public abstract Optional<com.mojang.authlib.GameProfile> shadow$get(UUID var1);

    @Shadow
    protected abstract long shadow$getNextOperation();

    @Override
    public boolean remove(GameProfile profile) {
        Objects.requireNonNull(profile, "profile");
        UUID uniqueId = profile.uniqueId();
        GameProfileCache_GameProfileInfoAccessor entry = this.profilesByUUID.remove(uniqueId);
        if (entry != null) {
            if (profile.name().isPresent()) {
                this.profilesByName.remove(profile.name().get().toLowerCase(Locale.ROOT));
            }
            return entry.invoker$getExpirationDate().getTime() >= System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public Collection<GameProfile> remove(Iterable<GameProfile> profiles) {
        Objects.requireNonNull(profiles, "profiles");
        ArrayList<GameProfile> result = new ArrayList<GameProfile>();
        for (GameProfile profile : profiles) {
            if (!this.remove(profile)) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public Collection<GameProfile> removeIf(Predicate<GameProfile> filter) {
        Objects.requireNonNull(filter, "filter");
        ArrayList<GameProfile> result = new ArrayList<GameProfile>();
        Iterator<GameProfileCache_GameProfileInfoAccessor> it = this.profilesByUUID.values().iterator();
        while (it.hasNext()) {
            boolean isExpired;
            GameProfileCache_GameProfileInfoAccessor entry = it.next();
            SpongeGameProfile profile = SpongeGameProfile.of(entry.invoker$getProfile());
            boolean bl = isExpired = entry.invoker$getExpirationDate().getTime() < System.currentTimeMillis();
            if (!isExpired && !filter.test(profile)) continue;
            it.remove();
            profile.name().ifPresent(name -> this.profilesByName.remove(name, entry));
            if (isExpired) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public void clear() {
        this.profilesByUUID.clear();
        this.profilesByName.clear();
    }

    @Override
    public Optional<GameProfile> findById(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.shadow$get(uniqueId).map(SpongeGameProfile::of);
    }

    @Override
    public Map<UUID, Optional<GameProfile>> findByIds(Iterable<UUID> uniqueIds) {
        Objects.requireNonNull(uniqueIds, "uniqueIds");
        HashMap<UUID, Optional<GameProfile>> result = new HashMap<UUID, Optional<GameProfile>>();
        for (UUID uniqueId : uniqueIds) {
            result.put(uniqueId, this.shadow$get(uniqueId).map(SpongeGameProfile::of));
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(result);
    }

    @Override
    public Optional<GameProfile> findByName(String name) {
        Objects.requireNonNull(name, "name");
        GameProfileCache_GameProfileInfoAccessor entry = this.profilesByName.get(name.toLowerCase(Locale.ROOT));
        if (entry != null && System.currentTimeMillis() >= entry.invoker$getExpirationDate().getTime()) {
            com.mojang.authlib.GameProfile profile = entry.invoker$getProfile();
            this.profilesByUUID.remove(profile.getId());
            this.profilesByName.remove(profile.getName().toLowerCase(Locale.ROOT));
            entry = null;
        }
        return Optional.ofNullable(this.api$updateLastAccess(entry));
    }

    @Override
    public Map<String, Optional<GameProfile>> findByNames(Iterable<String> names) {
        Objects.requireNonNull(names, "names");
        HashMap result = Maps.newHashMap();
        for (String name : names) {
            result.put(name, this.findByName(name));
        }
        return ImmutableMap.copyOf((Map)result);
    }

    @Override
    public Stream<GameProfile> stream() {
        return this.profilesByName.values().stream().map(entry -> SpongeGameProfile.of(entry.invoker$getProfile()));
    }

    @Override
    public Collection<GameProfile> all() {
        return (Collection)this.profilesByName.values().stream().map(this::api$updateLastAccess).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Stream<GameProfile> streamOfMatches(String name) {
        String search = Objects.requireNonNull(name, "name").toLowerCase(Locale.ROOT);
        return this.profilesByName.values().stream().filter(profile -> profile.invoker$getProfile().getName() != null).filter(profile -> profile.invoker$getProfile().getName().toLowerCase(Locale.ROOT).startsWith(search)).map(this::api$updateLastAccess);
    }

    @Override
    public Collection<GameProfile> allMatches(String name) {
        return (Collection)this.streamOfMatches(name).collect(ImmutableSet.toImmutableSet());
    }

    @Nullable
    private SpongeGameProfile api$updateLastAccess(@Nullable GameProfileCache_GameProfileInfoAccessor entry) {
        if (entry == null) {
            return null;
        }
        entry.invoker$setLastAccess(this.shadow$getNextOperation());
        return SpongeGameProfile.of(entry.invoker$getProfile());
    }
}

