/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.entity.raid;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.spongepowered.api.data.type.RaidStatus;
import org.spongepowered.api.raid.RaidWave;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.entity.raid.RaidBridge;

@Mixin(value={Raid.class})
public abstract class RaidMixin_API
implements org.spongepowered.api.raid.Raid {
    @Shadow
    @Final
    private Map<Integer, Set<Raider>> groupRaiderMap;
    @Shadow
    @Final
    @Mutable
    private ServerBossEvent raidEvent;
    @Shadow
    private Raid.RaidStatus status;

    @Shadow
    public abstract Level shadow$getLevel();

    @Shadow
    public abstract float shadow$getHealthOfLivingRaiders();

    @Shadow
    public abstract int shadow$getGroupsSpawned();

    @Override
    public ServerWorld world() {
        return (ServerWorld)this.shadow$getLevel();
    }

    @Override
    public BossBar bossBar() {
        return SpongeAdventure.asAdventure((BossEvent)this.raidEvent);
    }

    @Override
    public void setBossBar(BossBar bossBar) {
        Preconditions.checkNotNull((Object)bossBar, (Object)"BossBar cannot be null.");
        this.raidEvent = SpongeAdventure.asVanillaServer(bossBar);
    }

    @Override
    public RaidStatus status() {
        return (RaidStatus)this.status;
    }

    @Override
    public Optional<RaidWave> currentWave() {
        return Optional.ofNullable(((RaidBridge)((Object)this)).bridge$getWaves().get(this.shadow$getGroupsSpawned()));
    }

    @Override
    public List<RaidWave> waves() {
        return new ArrayList<RaidWave>(((RaidBridge)((Object)this)).bridge$getWaves().values());
    }

    @Override
    public int totalWaveAmount() {
        return this.groupRaiderMap.size();
    }

    @Override
    public double health() {
        return this.shadow$getHealthOfLivingRaiders();
    }
}

