/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.AABB;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={EntityGetter.class})
public interface EntityGetterMixin_API
extends EntityVolume {
    @Shadow
    public List<net.minecraft.world.entity.Entity> shadow$getEntities(@Nullable net.minecraft.world.entity.Entity var1, AABB var2, @Nullable Predicate<? super net.minecraft.world.entity.Entity> var3);

    @Shadow
    public <T extends net.minecraft.world.entity.Entity> List<T> shadow$getEntitiesOfClass(Class<? extends T> var1, AABB var2, @Nullable Predicate<? super T> var3);

    @Shadow
    public List<? extends Player> shadow$players();

    @Shadow
    public List<net.minecraft.world.entity.Entity> shadow$getEntities(@Nullable net.minecraft.world.entity.Entity var1, AABB var2);

    @Override
    default public Vector3i min() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public Vector3i max() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public boolean contains(int x, int y, int z) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public boolean isAreaAvailable(int x, int y, int z) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public Optional<Entity> entity(UUID uuid) {
        return Optional.empty();
    }

    @Override
    default public Collection<? extends org.spongepowered.api.entity.living.player.Player> players() {
        return Collections.unmodifiableCollection(this.shadow$players());
    }

    @Override
    default public Collection<? extends Entity> entities() {
        return (Collection)ImmutableList.copyOf(this.shadow$getEntities(null, VecHelper.toMinecraftAABB(org.spongepowered.api.util.AABB.of(this.min(), this.max()))));
    }

    @Override
    default public Collection<? extends Entity> entities(org.spongepowered.api.util.AABB box, Predicate<? super Entity> filter) {
        return this.shadow$getEntities(null, VecHelper.toMinecraftAABB(box), VolumeStreamUtils.apiToImplPredicate(filter));
    }

    default public <E extends Entity> Collection<? extends E> entities(Class<? extends E> entityClass, org.spongepowered.api.util.AABB box, @Nullable Predicate<? super E> predicate) {
        Predicate<net.minecraft.world.entity.Entity> filter = entity -> predicate == null || entityClass.isInstance(entity) && predicate.test((Object)((Entity)entity));
        List<net.minecraft.world.entity.Entity> ts = this.shadow$getEntitiesOfClass(entityClass, VecHelper.toMinecraftAABB(box), filter);
        return ts;
    }
}

