/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.LevelData;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.chunk.ChunkBiomeContainerAccessor;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={LevelAccessor.class})
@Implements(value={@Interface(iface=WorldLike.class, prefix="worldLike$", remap=Interface.Remap.NONE)})
public interface LevelAccessorMixin_API<P extends WorldLike<P>>
extends WorldLike<P> {
    @Shadow
    public boolean shadow$hasChunk(int var1, int var2);

    @Shadow
    public Random shadow$getRandom();

    @Shadow
    public LevelData shadow$getLevelData();

    @Override
    default public boolean setBiome(int x, int y, int z, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        ChunkAccess iChunk = ((LevelReader)this).getChunk(new BlockPos(x, y, z));
        if (iChunk == null) {
            return false;
        }
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> (ChunkBiomeContainerAccessor)iChunk.getBiomes(), () -> iChunk.setUnsaved(true));
    }

    @Override
    default public Vector3i min() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public Vector3i max() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public Vector3i size() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public boolean contains(int x, int y, int z) {
        return this.shadow$hasChunk(x >> 4, z >> 4);
    }

    @Override
    default public boolean isAreaAvailable(int x, int y, int z) {
        return this.shadow$hasChunk(x >> 4, z >> 4);
    }

    @Override
    default public Optional<Entity> entity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Intrinsic
    default public Random worldLike$random() {
        return this.shadow$getRandom();
    }

    @Override
    default public Difficulty difficulty() {
        return (Difficulty)this.shadow$getLevelData().getDifficulty();
    }

    @Override
    default public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        Objects.requireNonNull(entities, "entities");
        return EntityUtil.spawnEntities(entities, x -> true, e -> e.level.addFreshEntity(e));
    }

    @Override
    default public boolean spawnEntity(Entity entity) {
        return ((LevelAccessor)this).addFreshEntity((net.minecraft.world.entity.Entity)Objects.requireNonNull(entity, "entity"));
    }

    @Override
    default public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        Objects.requireNonNull(blockState, "blockState");
        Objects.requireNonNull(flag, "flag");
        if (!((Level)this).isInWorldBounds(new BlockPos(x, y, z))) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        try (@Nullable PhaseContext<@NonNull ?> context = PluginPhase.State.BLOCK_WORKER.switchIfNecessary(PhaseTracker.SERVER);){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean bl = ((LevelAccessor)this).setBlock(new BlockPos(x, y, z), (net.minecraft.world.level.block.state.BlockState)blockState, ((SpongeBlockChangeFlag)flag).getRawFlag());
            return bl;
        }
    }
}

