/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;

@Mixin(value={ServerEntity.class})
public abstract class ServerEntityMixin {
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    @Final
    @Mutable
    private Consumer<Packet<?>> broadcast;

    @Inject(method={"removePairing"}, at={@At(value="RETURN")})
    private void impl$removeHumanFromPlayerClient(ServerPlayer viewer, CallbackInfo ci) {
        if (this.entity instanceof HumanEntity) {
            ((HumanEntity)this.entity).untrackFrom(viewer);
        }
    }

    @Redirect(method={"sendPairingData"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", ordinal=0))
    public void impl$sendHumanSpawnPacket(Consumer<Packet<?>> consumer, Object spawnPacket) {
        if (!(this.entity instanceof HumanEntity)) {
            consumer.accept((Packet)spawnPacket);
            return;
        }
        HumanEntity human = (HumanEntity)this.entity;
        consumer.accept((Packet<?>)human.createPlayerListPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER));
        consumer.accept((Packet)spawnPacket);
        ClientboundPlayerInfoPacket removePacket = human.createPlayerListPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER);
        if (human.canRemoveFromListImmediately()) {
            consumer.accept((Packet<?>)removePacket);
        } else {
            human.removeFromTabListDelayed(null, removePacket);
        }
    }

    @Inject(method={"sendDirtyEntityData"}, at={@At(value="HEAD")})
    public void impl$sendHumanMetadata(CallbackInfo ci) {
        if (!(this.entity instanceof HumanEntity)) {
            return;
        }
        HumanEntity human = (HumanEntity)this.entity;
        Stream<Packet<?>> packets = human.popQueuedPackets(null);
        packets.forEach(this.broadcast);
    }

    @ModifyArg(method={"sendDirtyEntityData"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ClientboundUpdateAttributesPacket;<init>(ILjava/util/Collection;)V"))
    private Collection<AttributeInstance> impl$injectScaledHealth(Collection<AttributeInstance> set) {
        if (this.entity instanceof ServerPlayer && ((ServerPlayerBridge)this.entity).bridge$isHealthScaled()) {
            ((ServerPlayerBridge)this.entity).bridge$injectScaledHealth(set);
        }
        return set;
    }

    @Redirect(method={"sendDirtyEntityData"}, at=@At(value="NEW", target="net/minecraft/network/protocol/game/ClientboundSetEntityDataPacket"))
    private ClientboundSetEntityDataPacket impl$createSpoofedPacket(int entityId, SynchedEntityData dataManager, boolean p_i46917_3_) {
        if (!(this.entity instanceof ServerPlayerBridge) || !((ServerPlayerBridge)this.entity).bridge$isHealthScaled()) {
            return new ClientboundSetEntityDataPacket(entityId, dataManager, p_i46917_3_);
        }
        float scaledHealth = ((ServerPlayerBridge)this.entity).bridge$getInternalScaledHealth();
        Float actualHealth = (Float)dataManager.get(LivingEntityAccessor.accessor$DATA_HEALTH_ID());
        dataManager.set(LivingEntityAccessor.accessor$DATA_HEALTH_ID(), (Object)Float.valueOf(scaledHealth));
        ClientboundSetEntityDataPacket spoofed = new ClientboundSetEntityDataPacket(entityId, dataManager, p_i46917_3_);
        dataManager.set(LivingEntityAccessor.accessor$DATA_HEALTH_ID(), (Object)actualHealth);
        return spoofed;
    }
}

