/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.animal.Animal;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.TristateResult;
import org.spongepowered.api.event.entity.BreedingEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={BreedGoal.class})
public abstract class BreedGoalMixin {
    @Shadow
    @Final
    protected Animal animal;
    @Shadow
    protected Animal partner;

    @Shadow
    @Nullable
    private Animal shadow$getFreePartner() {
        return null;
    }

    @Nullable
    @Redirect(method={"canUse"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/BreedGoal;getFreePartner()Lnet/minecraft/world/entity/animal/Animal;"))
    private Animal impl$callFindMateEvent(BreedGoal entityAIMate) {
        Animal nearbyMate = this.shadow$getFreePartner();
        if (nearbyMate == null) {
            return null;
        }
        if (ShouldFire.BREEDING_EVENT_FIND_MATE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this.animal);
                BreedingEvent.FindMate event = SpongeEventFactory.createBreedingEventFindMate(frame.currentCause(), TristateResult.Result.DEFAULT, TristateResult.Result.DEFAULT, (org.spongepowered.api.entity.living.animal.Animal)nearbyMate, true);
                if (SpongeCommon.post(event) || event.result() == TristateResult.Result.DENY) {
                    nearbyMate = null;
                }
            }
        }
        return nearbyMate;
    }
}

