/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;

@Mixin(value={FireworkRocketEntity.class})
public abstract class FireworkRocketEntityMixin
extends EntityMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int life;
    @Shadow
    private int lifetime;
    private ProjectileSource impl$projectileSource = UnknownProjectileSource.UNKNOWN;
    private int impl$explosionRadius = 0;

    @Override
    public int bridge$getFuseDuration() {
        return this.lifetime;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.lifetime = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.lifetime - this.life;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.life = 0;
        this.lifetime = fuseTicks;
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionRadius = radius == null ? 0 : radius;
    }

    @Redirect(method={"explode()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V"))
    private void impl$useSpongeExplosion(Level world, Entity self, byte state) {
        if (this.level.isClientSide) {
            world.broadcastEntityEvent(self, state);
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.impl$projectileSource);
            SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().sourceExplosive((FireworkRocket)((Object)this)).location(((FireworkRocket)((Object)this)).serverLocation()).radius(this.impl$explosionRadius)).ifPresent(explosion -> world.broadcastEntityEvent(self, state));
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void impl$postPrimeEvent(CallbackInfo ci) {
        if (this.life == 1 && !this.level.isClientSide) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.impl$projectileSource);
                this.bridge$postPrime();
            }
        }
    }
}

