/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.item;

import java.util.OptionalInt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ServerItemCooldowns;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.living.player.CooldownEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.item.ItemCooldownsMixin;

@Mixin(value={ServerItemCooldowns.class})
public abstract class ServerItemCooldownsMixin
extends ItemCooldownsMixin {
    @Shadow
    @Final
    private ServerPlayer player;

    @Shadow
    protected abstract void onCooldownStarted(Item var1, int var2);

    @Override
    protected int impl$throwSetCooldownEvent(ItemType type, int ticks) {
        if (ticks == 0) {
            return 0;
        }
        OptionalInt beforeCooldown = ((CooldownTracker)((Object)this)).cooldown(type);
        CooldownEvent.Set event = SpongeEventFactory.createCooldownEventSet(PhaseTracker.getCauseStackManager().currentCause(), ticks, ticks, type, (org.spongepowered.api.entity.living.player.server.ServerPlayer)this.player, beforeCooldown);
        if (Sponge.eventManager().post(event)) {
            this.onCooldownStarted((Item)type, beforeCooldown.orElse(0));
            return -1;
        }
        return event.newCooldown();
    }

    @Override
    protected void impl$throwEndCooldownEvent(ItemType type) {
        CooldownEvent.End event = SpongeEventFactory.createCooldownEventEnd(PhaseTracker.getCauseStackManager().currentCause(), type, (org.spongepowered.api.entity.living.player.server.ServerPlayer)this.player);
        Sponge.eventManager().post(event);
    }
}

