/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.inventory;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;

@Mixin(value={CraftingMenu.class})
public abstract class CraftingMenuMixin_Inventory {
    @Redirect(method={"slotChangedCraftingGrid"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ResultContainer;setItem(ILnet/minecraft/world/item/ItemStack;)V"))
    private static void beforeSlotChangedCraftingGrid(ResultContainer resultContainer, int slotId, ItemStack itemStack, AbstractContainerMenu param0, Level param1, Player player, CraftingContainer craftingContainer, ResultContainer resultcontainer) {
        resultContainer.setItem(slotId, itemStack);
        Inventory inv = ((Inventory)player.containerMenu).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(inv instanceof CraftingInventory)) {
            SpongeCommon.logger().warn("Detected crafting but Sponge could not get a CraftingInventory for " + player.containerMenu.getClass().getName());
            return;
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        if (!context.isRestoring()) {
            TransactionalCaptureSupplier transactor = context.getTransactor();
            transactor.logCraftingPreview((ServerPlayer)player, (CraftingInventory)inv, craftingContainer);
        }
    }
}

