/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import co.aikar.timings.Timing;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.TickNextTickData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.TickNextTickDataBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.block.TrackableBlockBridge;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.effect.CheckBlockPostPlacementIsSameEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyClientEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyNeighborSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.PerformBlockDropsFromDestruction;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveTileEntityFromChunkEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.SetAndRegisterBlockEntityToLevelChunk;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateConnectingBlocksEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateLightSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateWorldRendererEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldBlockChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldDestroyBlockLevelEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.TileEntityPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.WorldPipeline;
import org.spongepowered.common.event.tracking.phase.generation.DeferredScheduledUpdatePhaseState;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.mixin.tracker.world.level.LevelMixin_Tracker;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin_Tracker
extends LevelMixin_Tracker
implements TrackedWorldBridge {
    @Shadow
    @Final
    List<ServerPlayer> players;

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;guardEntityTick(Ljava/util/function/Consumer;Lnet/minecraft/world/entity/Entity;)V"))
    private void tracker$wrapNormalEntityTick(ServerLevel level, Consumer<net.minecraft.world.entity.Entity> entityUpdateConsumer, net.minecraft.world.entity.Entity entity) {
        Timing entityTickTiming = ((TimingBridge)entity.getType()).bridge$timings();
        entityTickTiming.startTiming();
        PhaseContext<@NonNull ?> currentState = PhaseTracker.SERVER.getPhaseContext();
        TrackingUtil.tickEntity(entityUpdateConsumer, entity);
        entityTickTiming.stopTiming();
    }

    @Override
    protected void tracker$wrapBlockEntityTick(TickingBlockEntity blockEntity) {
        TrackingUtil.tickTileEntity(this, blockEntity);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"tickBlock(Lnet/minecraft/world/level/TickNextTickData;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapBlockTick(BlockState blockState, ServerLevel worldIn, BlockPos posIn, Random randomIn, TickNextTickData<Block> entry) {
        if (((TickNextTickDataBridge)entry).bridge$isPartOfWorldGeneration()) {
            try (@NonNull DeferredScheduledUpdatePhaseState.Context context = ((DeferredScheduledUpdatePhaseState.Context)GenerationPhase.State.DEFERRED_SCHEDULED_UPDATE.createPhaseContext(PhaseTracker.SERVER).source(this)).scheduledUpdate(entry);){
                context.buildAndSwitch();
                blockState.tick(worldIn, posIn, randomIn);
            }
            return;
        }
        TrackingUtil.updateTickBlock(this, blockState, posIn, randomIn);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"tickLiquid(Lnet/minecraft/world/level/TickNextTickData;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"))
    private void tracker$wrapFluidTick(FluidState fluidState, net.minecraft.world.level.Level worldIn, BlockPos pos, TickNextTickData<Fluid> entry) {
        if (((TickNextTickDataBridge)entry).bridge$isPartOfWorldGeneration()) {
            try (@NonNull DeferredScheduledUpdatePhaseState.Context context = ((DeferredScheduledUpdatePhaseState.Context)GenerationPhase.State.DEFERRED_SCHEDULED_UPDATE.createPhaseContext(PhaseTracker.SERVER).source(this)).scheduledUpdate(entry);){
                context.buildAndSwitch();
                fluidState.tick(worldIn, pos);
            }
            return;
        }
        TrackingUtil.updateTickFluid(this, fluidState, pos);
    }

    @Redirect(method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;randomTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapBlockRandomTick(BlockState blockState, ServerLevel worldIn, BlockPos posIn, Random randomIn) {
        try (Timing timing = ((TimingBridge)blockState.getBlock()).bridge$timings();){
            timing.startTiming();
            TrackingUtil.randomTickBlock(this, blockState, posIn, this.random);
        }
    }

    @Redirect(method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;randomTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapFluidRandomTick(FluidState fluidState, net.minecraft.world.level.Level worldIn, BlockPos pos, Random random) {
        TrackingUtil.randomTickFluid(this, fluidState, pos, this.random);
    }

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V", args={"ldc=thunder"})})
    private void tracker$startWeatherTickPhase(LevelChunk param0, int param1, CallbackInfo ci) {
        ((PhaseContext)TickPhase.Tick.WEATHER.createPhaseContext(PhaseTracker.SERVER)).buildAndSwitch();
    }

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=tickBlocks"})})
    private void tracker$closeWeatherTickPhase(LevelChunk param0, int param1, CallbackInfo ci) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        if (context.getState() != TickPhase.Tick.WEATHER) {
            throw new IllegalStateException("Expected to be in a Weather ticking state, but we aren't.");
        }
        context.close();
    }

    @Redirect(method={"doBlockEvent(Lnet/minecraft/world/level/BlockEventData;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;triggerEvent(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;II)Z"))
    private boolean tracker$wrapBlockStateEventReceived(BlockState recievingState, net.minecraft.world.level.Level thisWorld, BlockPos targetPos, int eventId, int flag, BlockEventData data) {
        return TrackingUtil.fireMinecraftBlockEvent((ServerLevel)this, data, recievingState);
    }

    @Redirect(method={"blockEvent(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;II)V"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;add(Ljava/lang/Object;)Z", remap=false))
    private boolean tracker$associatePhaseContextDataWithBlockEvent(ObjectLinkedOpenHashSet<BlockEventData> list, Object data, BlockPos pos, Block blockIn, int eventID, int eventParam) {
        PhaseContext<@NonNull ?> currentContext = PhaseTracker.getInstance().getPhaseContext();
        BlockEventData blockEventData = (BlockEventData)data;
        TrackableBlockEventDataBridge blockEvent = (TrackableBlockEventDataBridge)blockEventData;
        if (currentContext.ignoresBlockEvent()) {
            return list.add((Object)blockEventData);
        }
        BlockState state = this.shadow$getBlockState(pos);
        if (((TrackableBridge)blockIn).bridge$allowsBlockEventCreation()) {
            blockEvent.bridge$setSourceUserUUID(currentContext.getActiveUserUUID());
            if (((BlockStateBridge)state).bridge$hasTileEntity()) {
                blockEvent.bridge$setTileEntity((org.spongepowered.api.block.entity.BlockEntity)this.shadow$getBlockEntity(pos));
            }
            if (blockEvent.bridge$getTileEntity() == null) {
                LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)this)).position(pos.getX(), pos.getY(), pos.getZ()).state((org.spongepowered.api.block.BlockState)state).build();
                blockEvent.bridge$setTickingLocatable(locatable);
            }
        }
        if (!((TrackableBridge)blockIn).bridge$allowsBlockEventCreation()) {
            return list.add((Object)((BlockEventData)data));
        }
        currentContext.appendNotifierToBlockEvent(this, pos, blockEvent);
        if (ShouldFire.CHANGE_BLOCK_EVENT_PRE && (blockIn instanceof PistonBaseBlock ? SpongeCommonEventFactory.handlePistonEvent(this, pos, state, eventID) : SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)((Object)this), pos).isCancelled())) {
            return false;
        }
        currentContext.getTransactor().logBlockEvent(state, this, pos, blockEvent);
        return list.add((Object)blockEventData);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public net.minecraft.world.level.Explosion tracker$triggerInternalExplosion(Explosion explosion, Function<? super net.minecraft.world.level.Explosion, ? extends PhaseContext<@NonNull ?>> contextCreator) {
        net.minecraft.world.level.Explosion mcExplosion;
        net.minecraft.world.level.Explosion originalExplosion = (net.minecraft.world.level.Explosion)explosion;
        if (ShouldFire.EXPLOSION_EVENT_PRE) {
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(PhaseTracker.SERVER.currentCause(), explosion, (ServerWorld)((Object)this));
            if (SpongeCommon.post(event)) {
                return (net.minecraft.world.level.Explosion)explosion;
            }
            explosion = event.explosion();
        }
        try {
            mcExplosion = (net.minecraft.world.level.Explosion)explosion;
        }
        catch (Exception e) {
            new org.spongepowered.asm.util.PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not").add("originate from this implementation.").add((Throwable)e).trace();
            return originalExplosion;
        }
        try (@NonNull ? ignored = contextCreator.apply((net.minecraft.world.level.Explosion)mcExplosion).source(explosion.sourceExplosive().orElse((Explosive)((Object)this)));){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean damagesTerrain = explosion.shouldBreakBlocks();
            mcExplosion.explode();
            mcExplosion.finalizeExplosion(true);
            if (!damagesTerrain) {
                mcExplosion.clearToBlow();
            }
            for (ServerPlayer playerEntity : this.players) {
                Vec3 knockback = (Vec3)mcExplosion.getHitPlayers().get(playerEntity);
                if (knockback == null) continue;
                playerEntity.connection.send((Packet)new ClientboundSetEntityMotionPacket(playerEntity.getId(), new Vec3(knockback.x, knockback.y, knockback.z)));
            }
        }
        return mcExplosion;
    }

    @Override
    public Optional<WorldPipeline.Builder> bridge$startBlockChange(BlockPos pos, BlockState newState, int flags) {
        if (((ServerLevel)this).isOutsideBuildHeight(pos)) {
            return Optional.empty();
        }
        if (this.shadow$isDebug()) {
            return Optional.empty();
        }
        if (this.bridge$isFake()) {
            return Optional.empty();
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        LevelChunk chunk = this.shadow$getChunkAt(pos);
        if (chunk.isEmpty()) {
            return Optional.empty();
        }
        BlockState currentState = chunk.getBlockState(pos);
        return Optional.of(this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag, 512));
    }

    private WorldPipeline.Builder bridge$makePipeline(BlockPos pos, BlockState currentState, BlockState newState, LevelChunk chunk, SpongeBlockChangeFlag spongeFlag, int limit) {
        TrackedLevelChunkBridge mixinChunk = (TrackedLevelChunkBridge)chunk;
        ChunkPipeline chunkPipeline = mixinChunk.bridge$createChunkPipeline(pos, newState, currentState, spongeFlag, limit);
        WorldPipeline.Builder worldPipelineBuilder = WorldPipeline.builder(chunkPipeline);
        worldPipelineBuilder.addEffect((pipeline, oldState, newState1, flag1, cursorLimit) -> {
            if (oldState == null) {
                return EffectResult.NULL_RETURN;
            }
            return EffectResult.NULL_PASS;
        }).addEffect(UpdateLightSideEffect.getInstance()).addEffect(CheckBlockPostPlacementIsSameEffect.getInstance()).addEffect(UpdateWorldRendererEffect.getInstance()).addEffect(NotifyClientEffect.getInstance()).addEffect(NotifyNeighborSideEffect.getInstance()).addEffect(UpdateConnectingBlocksEffect.getInstance());
        return worldPipelineBuilder;
    }

    @Override
    public boolean setBlock(BlockPos pos, BlockState newState, int flags, int limit) {
        if (((ServerLevel)this).isOutsideBuildHeight(pos)) {
            return false;
        }
        if (this.shadow$isDebug()) {
            return false;
        }
        if (this.bridge$isFake()) {
            return super.setBlock(pos, newState, flags, limit);
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        LevelChunk chunk = this.shadow$getChunkAt(pos);
        if (chunk.isEmpty()) {
            return false;
        }
        BlockState currentState = chunk.getBlockState(pos);
        if (currentState == newState) {
            return false;
        }
        WorldPipeline pipeline = this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag, limit).addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
        return pipeline.processEffects(instance.getPhaseContext(), currentState, newState, pos, null, spongeFlag, limit);
    }

    @Override
    public boolean destroyBlock(BlockPos pos, boolean doDrops, @Nullable net.minecraft.world.entity.Entity p_241212_3_, int limit) {
        BlockState currentState = this.shadow$getBlockState(pos);
        if (currentState.isAir()) {
            return false;
        }
        if (this.bridge$isFake()) {
            return super.destroyBlock(pos, doDrops, p_241212_3_, limit);
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        FluidState fluidstate = this.shadow$getFluidState(pos);
        BlockState emptyBlock = fluidstate.createLegacyBlock();
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(3);
        LevelChunk chunk = this.shadow$getChunkAt(pos);
        if (chunk.isEmpty()) {
            return false;
        }
        WorldPipeline.Builder pipelineBuilder = this.bridge$makePipeline(pos, currentState, emptyBlock, chunk, spongeFlag, limit).addEffect(WorldDestroyBlockLevelEffect.getInstance());
        if (doDrops) {
            pipelineBuilder.addEffect(PerformBlockDropsFromDestruction.getInstance());
        }
        WorldPipeline pipeline = pipelineBuilder.addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
        return pipeline.processEffects(instance.getPhaseContext(), currentState, emptyBlock, pos, p_241212_3_, spongeFlag, limit);
    }

    @Override
    public SpongeBlockSnapshot bridge$createSnapshot(BlockState state, BlockPos pos, BlockChangeFlag updateFlag) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.reset();
        builder.blockState(state).world((ServerLevel)this).position(VecHelper.toVector3i(pos));
        LevelChunk chunk = this.shadow$getChunkAt(pos);
        if (chunk == null) {
            return builder.flag(updateFlag).build();
        }
        Optional<UUID> creator = ((LevelChunkBridge)chunk).bridge$getBlockCreatorUUID(pos);
        Optional<UUID> notifier = ((LevelChunkBridge)chunk).bridge$getBlockNotifierUUID(pos);
        creator.ifPresent(builder::creator);
        notifier.ifPresent(builder::notifier);
        boolean hasTileEntity = ((BlockStateBridge)state).bridge$hasTileEntity();
        BlockEntity tileEntity = chunk.getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        if ((hasTileEntity || tileEntity != null) && tileEntity != null) {
            CompoundTag nbt = new CompoundTag();
            try {
                tileEntity.save(nbt);
                builder.addUnsafeCompound(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        builder.flag(updateFlag);
        return builder.build();
    }

    @Override
    public void shadow$removeBlockEntity(BlockPos pos) {
        BlockPos immutable = pos.immutable();
        BlockEntity tileentity = this.shadow$getBlockEntity(immutable);
        if (tileentity == null) {
            return;
        }
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            super.shadow$removeBlockEntity(immutable);
            return;
        }
        PhaseContext<@NonNull ?> current = PhaseTracker.SERVER.getPhaseContext();
        if (current.getTransactor().logTileRemoval(tileentity, () -> (ServerLevel)this)) {
            TileEntityPipeline pipeline = TileEntityPipeline.kickOff((ServerLevel)this, immutable).addEffect(RemoveTileEntityFromChunkEffect.getInstance()).build();
            pipeline.processEffects(current, new PipelineCursor(tileentity.getBlockState(), 0, immutable, tileentity, null, 512));
            return;
        }
        super.shadow$removeBlockEntity(immutable);
    }

    @Override
    public void shadow$setBlockEntity(BlockEntity proposed) {
        PhaseContext<?> current;
        BlockPos immutable = proposed.getBlockPos().immutable();
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            super.shadow$setBlockEntity(proposed);
            return;
        }
        if (proposed != null && proposed.getLevel() != (ServerLevel)this) {
            proposed.setLevel((net.minecraft.world.level.Level)((ServerLevel)this));
        }
        if ((current = PhaseTracker.SERVER.getPhaseContext()).doesBlockEventTracking()) {
            @Nullable BlockEntity existing = this.shadow$getChunkAt(immutable).getBlockEntity(immutable);
            if (current.getTransactor().logTileReplacement(immutable, existing, proposed, () -> (ServerLevel)this)) {
                TileEntityPipeline pipeline = TileEntityPipeline.kickOff((ServerLevel)this, immutable).addEffect(SetAndRegisterBlockEntityToLevelChunk.getInstance()).build();
                pipeline.processEffects(current, new PipelineCursor(proposed.getBlockState(), 0, immutable, proposed, null, 512));
                return;
            }
        }
        super.shadow$setBlockEntity(proposed);
    }

    @Override
    public void shadow$neighborChanged(BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos immutableTarget = pos.immutable();
        BlockPos immutableFrom = fromPos.immutable();
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped("Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.", new Object[0]).add().add(new Exception("Async Block Notifcation Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        if (this.bridge$isFake()) {
            super.shadow$neighborChanged(immutableTarget, blockIn, immutableFrom);
            return;
        }
        LevelChunk targetChunk = this.shadow$getChunkAt(immutableTarget);
        BlockState targetBlockState = targetChunk.getBlockState(immutableTarget);
        if (!((TrackableBlockBridge)targetBlockState.getBlock()).bridge$overridesNeighborNotificationLogic()) {
            return;
        }
        PhaseContext<@NonNull ?> peek = server.getPhaseContext();
        try {
            Supplier<ServerLevel> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier((ServerLevel)this, "ServerWorld");
            @Nullable BlockEntity existingTile = targetChunk.getBlockEntity(immutableTarget, LevelChunk.EntityCreationType.CHECK);
            peek.getTransactor().logNeighborNotification(worldSupplier, immutableFrom, blockIn, immutableTarget, targetBlockState, existingTile);
            peek.associateNeighborStateNotifier(immutableFrom, targetBlockState.getBlock(), immutableTarget, (ServerLevel)this, PlayerTracker.Type.NOTIFIER);
            targetBlockState.neighborChanged((net.minecraft.world.level.Level)((ServerLevel)this), immutableTarget, blockIn, immutableFrom, false);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Exception while updating neighbours");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block being updated");
            crashreportcategory.setDetail("Source block type", () -> {
                try {
                    return String.format("ID #%s (%s // %s)", Registry.BLOCK.getKey((Object)blockIn), blockIn.getDescriptionId(), blockIn.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + Registry.BLOCK.getKey((Object)blockIn);
                }
            });
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)((ServerLevel)this), (BlockPos)immutableTarget, (BlockState)targetBlockState);
            throw new ReportedException(crashreport);
        }
    }

    @Inject(method={"addEntity(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;addNewEntity(Lnet/minecraft/world/level/entity/EntityAccess;)Z")}, cancellable=true)
    private void tracker$throwPreEventAndRecord(net.minecraft.world.entity.Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        if (this.bridge$isFake()) {
            return;
        }
        PhaseTracker tracker = PhaseTracker.SERVER;
        if (tracker.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> current = tracker.getPhaseContext();
        if (!current.doesAllowEntitySpawns()) {
            cir.setReturnValue((Object)false);
            return;
        }
        try (CauseStackManager.StackFrame frame = tracker.pushCauseFrame();){
            ArrayList<Entity> entities = new ArrayList<Entity>();
            entities.add((Entity)entityIn);
            frame.addContext(EventContextKeys.SPAWN_TYPE, current.getSpawnTypeForTransaction(entityIn));
            SpawnEntityEvent.Pre pre = SpongeEventFactory.createSpawnEntityEventPre(frame.currentCause(), entities);
            Sponge.eventManager().post(pre);
            if (pre.isCancelled() || entities.isEmpty()) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
        if (current.allowsBulkEntityCaptures()) {
            current.getTransactor().logEntitySpawn(current, this, entityIn);
        }
    }
}

