/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;

public final class DamageSourceToTypeProvider {
    public static final DamageSourceToTypeProvider INSTANCE = new DamageSourceToTypeProvider();
    private final Map<String, Supplier<? extends DamageType>> mappings = new HashMap<String, Supplier<? extends DamageType>>();

    DamageSourceToTypeProvider() {
        this.mappings.put("anvil", DamageTypes.CONTACT);
        this.mappings.put("arrow", DamageTypes.PROJECTILE);
        this.mappings.put("cactus", DamageTypes.CONTACT);
        this.mappings.put("cramming", DamageTypes.CONTACT);
        this.mappings.put("dragonbreath", DamageTypes.MAGIC);
        this.mappings.put("drown", DamageTypes.DROWN);
        this.mappings.put("explosion.player", DamageTypes.EXPLOSIVE);
        this.mappings.put("fall", DamageTypes.FALL);
        this.mappings.put("fallingblock", DamageTypes.CONTACT);
        this.mappings.put("fireworks", DamageTypes.EXPLOSIVE);
        this.mappings.put("flyintowall", DamageTypes.CONTACT);
        this.mappings.put("generic", DamageTypes.GENERIC);
        this.mappings.put("hotfloor", DamageTypes.MAGMA);
        this.mappings.put("indirectmagic", DamageTypes.MAGIC);
        this.mappings.put("infire", DamageTypes.FIRE);
        this.mappings.put("inwall", DamageTypes.SUFFOCATE);
        this.mappings.put("lava", DamageTypes.FIRE);
        this.mappings.put("lightningbolt", DamageTypes.PROJECTILE);
        this.mappings.put("magic", DamageTypes.MAGIC);
        this.mappings.put("mob", DamageTypes.ATTACK);
        this.mappings.put("onfire", DamageTypes.FIRE);
        this.mappings.put("outofworld", DamageTypes.VOID);
        this.mappings.put("player", DamageTypes.ATTACK);
        this.mappings.put("starve", DamageTypes.HUNGER);
        this.mappings.put("thorns", DamageTypes.MAGIC);
        this.mappings.put("thrown", DamageTypes.PROJECTILE);
        this.mappings.put("wither", DamageTypes.MAGIC);
    }

    public Optional<Supplier<? extends DamageType>> get(String key) {
        return Optional.ofNullable(this.mappings.get(((String)Preconditions.checkNotNull((Object)key)).toLowerCase(Locale.ENGLISH)));
    }

    public Supplier<? extends DamageType> getOrCustom(String key) {
        Supplier<? extends DamageType> damageType = this.mappings.get(((String)Preconditions.checkNotNull((Object)key)).toLowerCase(Locale.ENGLISH));
        if (damageType == null) {
            this.addCustom(key);
            return DamageTypes.CUSTOM;
        }
        return damageType;
    }

    public Optional<String> getKey(DamageType value) {
        throw new UnsupportedOperationException("We do not support this!");
    }

    public void addCustom(String in) {
        this.mappings.put(in.toLowerCase(Locale.ENGLISH), DamageTypes.CUSTOM);
    }
}

