/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.scheduler.SpongeTask;

public final class SpongeScheduledTask
implements ScheduledTask {
    private final SpongeScheduler scheduler;
    final SpongeTask task;
    private final UUID uniqueId;
    private final String name;
    private long timestamp;
    private ScheduledTaskState state;
    private boolean isCancelled = false;

    SpongeScheduledTask(SpongeScheduler scheduler, SpongeTask task, String name) {
        this.scheduler = scheduler;
        this.task = task;
        this.name = name;
        this.uniqueId = UUID.randomUUID();
        this.state = ScheduledTaskState.WAITING;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public Task task() {
        return this.task;
    }

    @Override
    public UUID uniqueId() {
        return this.uniqueId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean cancel() {
        boolean success = this.state() == ScheduledTaskState.RUNNING || this.state() == ScheduledTaskState.EXECUTING;
        this.state = ScheduledTaskState.CANCELED;
        this.isCancelled = true;
        return success;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    long timestamp() {
        return this.timestamp;
    }

    void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    long nextExecutionTimestamp() {
        if (this.state.isActive) {
            return this.timestamp + this.task.interval;
        }
        return this.timestamp + this.task.delay;
    }

    ScheduledTaskState state() {
        return this.state;
    }

    void setState(ScheduledTaskState state) {
        this.state = state;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("task", (Object)this.task).toString();
    }

    public static enum ScheduledTaskState {
        WAITING(false),
        SWITCHING(true),
        EXECUTING(true),
        RUNNING(true),
        CANCELED(false);

        public final boolean isActive;

        private ScheduledTaskState(boolean active) {
            this.isActive = active;
        }
    }
}

