/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import org.spongepowered.common.accessor.world.scores.ObjectiveAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreAccessor;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.bridge.world.scores.ScoreBridge;

public final class SpongeScore
implements org.spongepowered.api.scoreboard.Score {
    private final Component name;
    public String legacyName;
    private int score;
    private boolean locked;
    private final Map<Objective, Score> scores = new HashMap<Objective, Score>();

    public SpongeScore(Component name) {
        this.name = name;
        this.legacyName = LegacyComponentSerializer.legacySection().serialize(name);
        if (this.legacyName.length() > 40) {
            throw new IllegalArgumentException(String.format("The score name %s is too long! It must be at most %s characters.", this.legacyName, 40));
        }
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public int score() {
        return this.score;
    }

    @Override
    public void setScore(int score) {
        this.score = score;
        this.updateScore();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    private void updateScore() {
        for (Score score : this.scores.values()) {
            int j = ((ScoreAccessor)score).accessor$count();
            ((ScoreAccessor)score).accessor$count(this.score);
            if (j == this.score && !((ScoreAccessor)score).accessor$forceUpdate()) continue;
            ((ScoreAccessor)score).accessor$forceUpdate(false);
            score.getScoreboard().onScoreChanged(score);
        }
    }

    @Override
    public Set<org.spongepowered.api.scoreboard.objective.Objective> objectives() {
        HashSet<org.spongepowered.api.scoreboard.objective.Objective> objectives = new HashSet<org.spongepowered.api.scoreboard.objective.Objective>();
        for (Objective objective : this.scores.keySet()) {
            objectives.add(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return objectives;
    }

    public Score getScoreFor(Objective objective) {
        if (this.scores.containsKey(objective)) {
            return this.scores.get(objective);
        }
        Score score = new Score(((ObjectiveAccessor)objective).accessor$scoreboard(), objective, this.legacyName);
        ((ScoreAccessor)score).accessor$count(this.score);
        ((ScoreBridge)score).bridge$setSpongeScore(this);
        this.scores.put(objective, score);
        return score;
    }

    public void removeScoreFor(Objective objective) {
        if (this.scores.remove(objective) == null) {
            throw new IllegalStateException("Attempting to remove an score without an entry!");
        }
    }
}

