/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.ServerScoreboard;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.common.SpongeCommon;

public final class SpongeScoreboardBuilder
implements Scoreboard.Builder {
    private List<Objective> objectives = new ArrayList<Objective>();
    private List<Team> teams = new ArrayList<Team>();

    @Override
    public Scoreboard.Builder objectives(List<Objective> objectives) {
        this.objectives = (List)Preconditions.checkNotNull(objectives, (Object)"Objectives cannot be null!");
        return this;
    }

    @Override
    public Scoreboard.Builder teams(List<Team> teams) {
        this.teams = (List)Preconditions.checkNotNull(teams, (Object)"Teams cannot be null!");
        return this;
    }

    @Override
    public Scoreboard.Builder from(Scoreboard value) {
        this.objectives = new ArrayList<Objective>(value.objectives());
        this.teams = new ArrayList<Team>(value.teams());
        return this;
    }

    @Override
    public Scoreboard.Builder reset() {
        this.objectives = new ArrayList<Objective>();
        this.teams = new ArrayList<Team>();
        return this;
    }

    @Override
    public Scoreboard build() throws IllegalStateException {
        Scoreboard scoreboard = (Scoreboard)new ServerScoreboard(SpongeCommon.server());
        for (Objective objective : this.objectives) {
            scoreboard.addObjective(objective);
        }
        for (Team team : this.teams) {
            scoreboard.registerTeam(team);
        }
        return scoreboard;
    }
}

