/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.tag;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.tag.TagTemplate;
import org.spongepowered.api.tag.TagType;
import org.spongepowered.common.SpongeCommon;

public final class SpongeTagTemplate
implements TagTemplate {
    private final ResourceKey key;
    private final TagType<@NonNull ?> tagType;
    private final boolean replace;
    private final Map<ResourceKey, Boolean> elements;
    private final Map<ResourceKey, Boolean> subTags;

    public SpongeTagTemplate(ResourceKey key, TagType<@NonNull ?> tagType, boolean replace, Map<ResourceKey, Boolean> elements, Map<ResourceKey, Boolean> subTags) {
        this.key = key;
        this.tagType = tagType;
        this.replace = replace;
        this.elements = elements;
        this.subTags = subTags;
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public TagType<@NonNull ?> tagType() {
        return this.tagType;
    }

    public boolean replace() {
        return this.replace;
    }

    public Map<ResourceKey, Boolean> elements() {
        return ImmutableMap.copyOf(this.elements);
    }

    public Map<ResourceKey, Boolean> subTags() {
        return ImmutableMap.copyOf(this.subTags);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        JsonObject jsonObject = this.toJson();
        try {
            DataContainer container = DataFormats.JSON.get().read(jsonObject.getAsString());
            container.set(DataQuery.of("replace"), this.replace);
            return container;
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Error reading json serialized by minecraft", (Throwable)e);
            return DataContainer.createNew();
        }
    }

    public JsonObject toJson() {
        Tag.Builder builder = new Tag.Builder();
        this.elements.forEach((k, v) -> {
            ResourceLocation location = (ResourceLocation)k;
            builder.add((Tag.Entry)(v != false ? new Tag.ElementEntry(location) : new Tag.OptionalElementEntry(location)), "N/A");
        });
        this.subTags.forEach((k, v) -> {
            ResourceLocation location = (ResourceLocation)k;
            builder.add((Tag.Entry)(v != false ? new Tag.TagEntry(location) : new Tag.OptionalTagEntry(location)), "N/A");
        });
        return builder.serializeToJson();
    }

    @Override
    public DataPackType type() {
        return DataPackTypes.TAG;
    }
}

