/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.generation.ConfigurableChunkGenerator;
import org.spongepowered.api.world.generation.config.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.common.accessor.world.level.dimension.DimensionTypeAccessor;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.SeedUtil;

public final class SpongeChunkGeneratorFactory
implements ChunkGenerator.Factory {
    @Override
    public <T extends FlatGeneratorConfig> ConfigurableChunkGenerator<T> flat(T config) {
        return (ConfigurableChunkGenerator)new FlatLevelSource((FlatLevelGeneratorSettings)config);
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, T config) {
        return (ConfigurableChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)Objects.requireNonNull(provider, "provider"), BootstrapProperties.worldGenSettings.seed(), () -> (NoiseGeneratorSettings)Objects.requireNonNull(config, "config"));
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, long seed, T config) {
        return (ConfigurableChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)Objects.requireNonNull(provider, "provider"), seed, () -> (NoiseGeneratorSettings)Objects.requireNonNull(config, "config"));
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, String seed, T config) {
        return this.noise(provider, SeedUtil.compute(seed), config);
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> overworld() {
        return (ConfigurableChunkGenerator)WorldGenSettings.makeDefaultOverworld((Registry)BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY), (Registry)BootstrapProperties.registries.registryOrThrow(Registry.NOISE_GENERATOR_SETTINGS_REGISTRY), (long)BootstrapProperties.worldGenSettings.seed());
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theNether() {
        return (ConfigurableChunkGenerator)DimensionTypeAccessor.invoker$defaultNetherGenerator((Registry<Biome>)BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY), (Registry<NoiseGeneratorSettings>)BootstrapProperties.registries.registryOrThrow(Registry.NOISE_GENERATOR_SETTINGS_REGISTRY), BootstrapProperties.worldGenSettings.seed());
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theEnd() {
        return (ConfigurableChunkGenerator)DimensionTypeAccessor.invoker$defaultEndGenerator((Registry<Biome>)BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY), (Registry<NoiseGeneratorSettings>)BootstrapProperties.registries.registryOrThrow(Registry.NOISE_GENERATOR_SETTINGS_REGISTRY), BootstrapProperties.worldGenSettings.seed());
    }
}

