/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import java.util.Objects;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlideSettings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.api.world.generation.config.noise.SamplingConfig;
import org.spongepowered.api.world.generation.config.noise.SlideConfig;

public final class SpongeNoiseConfig {
    private SpongeNoiseConfig() {
    }

    public static final class FactoryImpl
    implements NoiseConfig.Factory {
        @Override
        public NoiseConfig overworld() {
            return Holder.OVERWORLD;
        }

        @Override
        public NoiseConfig nether() {
            return Holder.NETHER;
        }

        @Override
        public NoiseConfig end() {
            return Holder.END;
        }

        private static final class Holder {
            private static final NoiseConfig OVERWORLD = (NoiseConfig)NoiseSettings.create((int)DimensionType.MIN_Y, (int)256, (NoiseSamplingSettings)new NoiseSamplingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), (NoiseSlideSettings)new NoiseSlideSettings(-10, 3, 0), (NoiseSlideSettings)new NoiseSlideSettings(-30, 0, 0), (int)1, (int)2, (double)1.0, (double)-0.46875, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
            private static final NoiseConfig NETHER = (NoiseConfig)NoiseSettings.create((int)DimensionType.MIN_Y, (int)128, (NoiseSamplingSettings)new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), (NoiseSlideSettings)new NoiseSlideSettings(120, 3, 0), (NoiseSlideSettings)new NoiseSlideSettings(320, 4, -1), (int)1, (int)2, (double)0.0, (double)0.019921875, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            private static final NoiseConfig END = (NoiseConfig)NoiseSettings.create((int)DimensionType.MIN_Y, (int)128, (NoiseSamplingSettings)new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), (NoiseSlideSettings)new NoiseSlideSettings(-3000, 64, -46), (NoiseSlideSettings)new NoiseSlideSettings(-30, 7, 1), (int)2, (int)1, (double)0.0, (double)0.0, (boolean)true, (boolean)false, (boolean)false, (boolean)false);

            private Holder() {
            }
        }
    }

    public static final class BuilderImpl
    implements NoiseConfig.Builder {
        public SamplingConfig sampling;
        public SlideConfig top;
        public SlideConfig bottom;
        public int minY;
        public int height;
        public int horizontalSize;
        public int verticalSize;
        public double densityFactor;
        public double densityOffset;
        public boolean simplexForSurface;
        public boolean randomizeDensityOffset;
        public boolean amplified;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseConfig.Builder minY(int minY) {
            this.minY = minY;
            return this;
        }

        @Override
        public NoiseConfig.Builder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        public NoiseConfig.Builder sampling(SamplingConfig sampling) {
            this.sampling = Objects.requireNonNull(sampling, "sampling");
            return this;
        }

        @Override
        public NoiseConfig.Builder top(SlideConfig top) {
            this.top = Objects.requireNonNull(top, "top");
            return this;
        }

        @Override
        public NoiseConfig.Builder bottom(SlideConfig bottom) {
            this.bottom = Objects.requireNonNull(bottom, "bottom");
            return this;
        }

        @Override
        public NoiseConfig.Builder horizontalSize(int horizontal) {
            this.horizontalSize = horizontal;
            return this;
        }

        @Override
        public NoiseConfig.Builder verticalSize(int vertical) {
            this.verticalSize = vertical;
            return this;
        }

        @Override
        public NoiseConfig.Builder densityFactor(double densityFactor) {
            this.densityFactor = densityFactor;
            return this;
        }

        @Override
        public NoiseConfig.Builder densityOffset(double densityOffset) {
            this.densityOffset = densityOffset;
            return this;
        }

        @Override
        public NoiseConfig.Builder simplexForSurface(boolean simplex) {
            this.simplexForSurface = simplex;
            return this;
        }

        @Override
        public NoiseConfig.Builder randomizeDensityOffset(boolean randomDensityOffset) {
            this.randomizeDensityOffset = randomDensityOffset;
            return this;
        }

        @Override
        public NoiseConfig.Builder amplified(boolean amplified) {
            this.amplified = amplified;
            return this;
        }

        @Override
        public NoiseConfig.Builder reset() {
            this.sampling = SamplingConfig.of(0.9999999814507745, 80.0, 0.9999999814507745, 160.0);
            this.top = SlideConfig.of(-10, 3, 0);
            this.bottom = SlideConfig.of(-30, 0, 0);
            this.height = 256;
            this.horizontalSize = 1;
            this.verticalSize = 2;
            this.densityFactor = 1.0;
            this.densityOffset = -0.46875;
            this.simplexForSurface = true;
            this.randomizeDensityOffset = true;
            this.amplified = false;
            return this;
        }

        @Override
        public NoiseConfig.Builder from(NoiseConfig value) {
            Objects.requireNonNull(value, "value");
            this.sampling = value.samplingConfig();
            this.top = value.topConfig();
            this.bottom = value.bottomConfig();
            this.height = value.height();
            this.horizontalSize = value.horizontalSize();
            this.verticalSize = value.verticalSize();
            this.densityFactor = value.densityFactor();
            this.densityOffset = value.densityOffset();
            this.simplexForSurface = value.simplexForSurface();
            this.randomizeDensityOffset = value.randomizeDensityOffset();
            this.amplified = value.amplified();
            return this;
        }

        public @NonNull NoiseConfig build() {
            Objects.requireNonNull(this.sampling, "sampling");
            Objects.requireNonNull(this.top, "top");
            Objects.requireNonNull(this.bottom, "bottom");
            return (NoiseConfig)NoiseSettings.create((int)this.minY, (int)this.height, (NoiseSamplingSettings)((NoiseSamplingSettings)this.sampling), (NoiseSlideSettings)((NoiseSlideSettings)this.top), (NoiseSlideSettings)((NoiseSlideSettings)this.bottom), (int)this.horizontalSize, (int)this.verticalSize, (double)this.densityFactor, (double)this.densityOffset, (boolean)this.simplexForSurface, (boolean)this.randomizeDensityOffset, (boolean)false, (boolean)this.amplified);
        }
    }
}

