/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.block;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.block.BlockVolumeFactory;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollectors;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.common.world.volume.buffer.block.ArrayImmutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.BlockBackingData;
import org.spongepowered.math.vector.Vector3i;

public class SpongeBlockVolumeFactory
implements BlockVolumeFactory {
    @Override
    public BlockVolume.Mutable empty(Palette<BlockState, BlockType> palette, RegistryReference<BlockType> defaultState, Vector3i min, Vector3i max) {
        return new ArrayMutableBlockBuffer(palette, defaultState, min, max.sub(min));
    }

    @Override
    public BlockVolume.Mutable copyFromRange(BlockVolume.Streamable<@NonNull ?> existing, Vector3i newMin, Vector3i newMax) {
        ArrayMutableBlockBuffer buffer = new ArrayMutableBlockBuffer(newMin, newMax.sub(newMin));
        existing.blockStateStream(newMin, newMax, StreamOptions.lazily()).apply(VolumeCollectors.of(buffer, VolumePositionTranslators.identity(), VolumeApplicators.applyBlocks()));
        return buffer;
    }

    @Override
    public BlockVolume.Mutable copy(BlockVolume.Streamable<@NonNull ?> existing) {
        ArrayMutableBlockBuffer buffer = new ArrayMutableBlockBuffer(existing.min(), existing.size());
        existing.blockStateStream(existing.min(), existing.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(buffer, VolumePositionTranslators.identity(), VolumeApplicators.applyBlocks()));
        return buffer;
    }

    @Override
    public BlockVolume.Immutable immutableOf(BlockVolume.Streamable<@NonNull ?> existing) {
        if (existing instanceof ArrayMutableBlockBuffer) {
            return this.createImmutableFromBufferData((ArrayMutableBlockBuffer)existing);
        }
        ArrayMutableBlockBuffer buffer = new ArrayMutableBlockBuffer(existing.min(), existing.size());
        existing.blockStateStream(existing.min(), existing.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(buffer, VolumePositionTranslators.identity(), VolumeApplicators.applyBlocks()));
        return this.createImmutableFromBufferData(buffer);
    }

    private ArrayImmutableBlockBuffer createImmutableFromBufferData(ArrayMutableBlockBuffer arrayBuffer) {
        BlockBackingData data = arrayBuffer.getCopiedBackingData();
        Palette.Immutable<BlockState, BlockType> immutablePalette = arrayBuffer.getPalette().asImmutable();
        return new ArrayImmutableBlockBuffer(immutablePalette, arrayBuffer.min(), arrayBuffer.size(), data);
    }

    @Override
    public BlockVolume.Immutable immutableOf(BlockVolume.Streamable<@NonNull ?> existing, Vector3i newMin, Vector3i newMax) {
        ArrayMutableBlockBuffer buffer = new ArrayMutableBlockBuffer(newMin, newMax.sub(newMin));
        existing.blockStateStream(newMin, newMax, StreamOptions.lazily()).apply(VolumeCollectors.of(buffer, VolumePositionTranslators.identity(), VolumeApplicators.applyBlocks()));
        return this.createImmutableFromBufferData(buffer);
    }
}

