/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.chat;

import java.util.Locale;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory2;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.ReusableObjectMessage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.adventure.NativeComponentRenderer;
import org.spongepowered.common.adventure.SpongeAdventure;

public class ReusableComponentMessageFactory
implements MessageFactory2 {
    private static final ThreadLocal<ComponentMessage> componentMessageThreadLocal = new ThreadLocal();
    private final ReusableMessageFactory backing = new ReusableMessageFactory();
    public static final ReusableComponentMessageFactory INSTANCE = new ReusableComponentMessageFactory();

    private ReusableComponentMessageFactory() {
    }

    private static ComponentMessage getComponentMessage() {
        @Nullable ComponentMessage message = componentMessageThreadLocal.get();
        if (message == null) {
            message = new ComponentMessage();
            componentMessageThreadLocal.set(message);
        }
        return message;
    }

    public Message newMessage(Object message) {
        ComponentMessage result = ReusableComponentMessageFactory.getComponentMessage();
        result.set(message);
        return result;
    }

    public Message newMessage(String message) {
        return this.backing.newMessage(message);
    }

    public Message newMessage(String message, Object ... params) {
        return this.backing.newMessage(message, params);
    }

    public Message newMessage(CharSequence charSequence) {
        return this.backing.newMessage(charSequence);
    }

    public Message newMessage(String message, Object p0) {
        return this.backing.newMessage(message, p0);
    }

    public Message newMessage(String message, Object p0, Object p1) {
        return this.backing.newMessage(message, p0, p1);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2) {
        return this.backing.newMessage(message, p0, p1, p2);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3) {
        return this.backing.newMessage(message, p0, p1, p2, p3);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.backing.newMessage(message, p0, p1, p2, p3, p4);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.backing.newMessage(message, p0, p1, p2, p3, p4, p5);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.backing.newMessage(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.backing.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.backing.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.backing.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    static class ComponentMessage
    extends ReusableObjectMessage {
        private static final long serialVersionUID = -3477272587468239708L;
        private static final ComponentRenderer<Locale> RENDERER = GlobalTranslator.renderer();

        ComponentMessage() {
        }

        public String getFormattedMessage() {
            Object param = this.getParameter();
            if (param instanceof ComponentLike) {
                return PlainTextComponentSerializer.plainText().serialize(RENDERER.render(((ComponentLike)param).asComponent(), (Object)Locale.getDefault()));
            }
            if (param instanceof Component) {
                return NativeComponentRenderer.apply((Component)param, Locale.getDefault()).getString();
            }
            return super.getFormattedMessage();
        }

        public void formatTo(StringBuilder buffer) {
            Object param = this.getParameter();
            if (param instanceof ComponentLike) {
                SpongeAdventure.flattener().flatten(RENDERER.render(((ComponentLike)param).asComponent(), (Object)Locale.getDefault()), buffer::append);
            } else if (param instanceof Component) {
                buffer.append(NativeComponentRenderer.apply((Component)param, Locale.getDefault()).getString());
            } else {
                super.formatTo(buffer);
            }
        }
    }
}

