/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.chat.console;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.spongepowered.common.SpongeCommon;

final class BrigadierJLineCompleter<S>
implements Completer {
    private final Supplier<@Nullable CommandDispatcher<S>> dispatcherProvider;
    private final Supplier<S> commandSourceProvider;

    public BrigadierJLineCompleter(Supplier<@Nullable CommandDispatcher<S>> dispatcherProvider, Supplier<S> commandSourceProvider) {
        this.dispatcherProvider = dispatcherProvider;
        this.commandSourceProvider = commandSourceProvider;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        CommandDispatcher<S> dispatcher = this.dispatcherProvider.get();
        if (dispatcher == null) {
            return;
        }
        String input = line.line();
        ParseResults parseResult = dispatcher.parse(input, this.commandSourceProvider.get());
        CompletableFuture suggestions = dispatcher.getCompletionSuggestions(parseResult, line.cursor());
        try {
            Suggestions result = (Suggestions)suggestions.get();
            for (Suggestion completion : result.getList()) {
                if (completion.getText().isEmpty()) continue;
                candidates.add(BrigadierJLineCompleter.candidateFromSuggestion(parseResult, completion));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            SpongeCommon.logger().error("Failed to tab complete", (Throwable)e);
        }
    }

    private static Candidate candidateFromSuggestion(ParseResults<?> result, Suggestion suggestion) {
        Message tooltip = suggestion.getTooltip();
        return new Candidate(suggestion.getText(), suggestion.getText(), null, tooltip == null ? null : tooltip.getString(), null, null, result.getExceptions().isEmpty());
    }
}

