/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.awt.GraphicsEnvironment;
import javax.swing.JOptionPane;

public class JavaVersionCheckUtils {
    private static final int INVALID_VERSION = -1;
    private static final String REQUIRED_VERSION = "16";
    private static final String ERROR_MESSAGE = "We have detected that you are running Java version %s, which is not supported!!\nIn order to run Sponge (and Minecraft 1.17+), you **must** be running a Java runtime version %s or above.\nThis can be downloaded from AdoptOpenJDK: https://adoptopenjdk.net/?variant=openjdk16&jvmVariant=hotspot";

    public static void ensureJava16() {
        String version = JavaVersionCheckUtils.getCurrentVersion();
        if (JavaVersionCheckUtils.getMajorVersion(version) < JavaVersionCheckUtils.getMajorVersion(REQUIRED_VERSION)) {
            String error = String.format(ERROR_MESSAGE, version, REQUIRED_VERSION);
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, error, "PEBKACException!", 0);
            }
            throw new RuntimeException(error);
        }
    }

    private static String getCurrentVersion() {
        return System.getProperty("java.version");
    }

    private static int getMajorVersion(String version) {
        String[] versionParts;
        if (version.contains("-")) {
            version = version.substring(0, version.indexOf(45));
        }
        if ((versionParts = (version = version.replace('_', '.')).split("\\.", -1)).length == 0) {
            return -1;
        }
        int majorVersion = JavaVersionCheckUtils.tryParseInt(versionParts[0]);
        if (majorVersion == 1 && versionParts.length > 1) {
            return JavaVersionCheckUtils.tryParseInt(versionParts[1]);
        }
        return majorVersion;
    }

    private static int tryParseInt(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

