/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core;

import net.minecraft.CrashReport;
import net.minecraft.SystemReport;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;

@Mixin(value={CrashReport.class})
public abstract class CrashReportMixin_Vanilla {
    @Shadow
    @Final
    private SystemReport systemReport;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void vanilla$addPluginsToEnvironment(CallbackInfo ci) {
        this.systemReport.setDetail("Plugins", () -> {
            StringBuilder result = new StringBuilder(64);
            for (PluginContainer container : Sponge.pluginManager().plugins()) {
                PluginMetadata metadata = container.metadata();
                String name = metadata.name().orElse(metadata.id());
                result.append("\n\t\t").append(name).append(" (").append(metadata.id()).append(") ").append(metadata.version());
            }
            return result.toString();
        });
    }
}

