/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.format;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import org.tinylog.Level;
import org.tinylog.format.AbstractMessageFormatter;
import org.tinylog.format.EndlessIterator;
import org.tinylog.provider.InternalLogger;

public class AdvancedMessageFormatter
extends AbstractMessageFormatter {
    private final DecimalFormatSymbols symbols;
    private final boolean escape;

    public AdvancedMessageFormatter(Locale locale, boolean escape) {
        this.symbols = new DecimalFormatSymbols(locale);
        this.escape = escape;
    }

    @Override
    public String format(String message, Object[] arguments) {
        return this.format(message, Arrays.asList(arguments).iterator());
    }

    private String format(String message, Iterator<Object> arguments) {
        int length = message.length();
        StringBuilder builder = new StringBuilder(length + 32);
        int openingTickIndex = -1;
        int openingCurlyBracketIndex = -1;
        int openingCurlyBracketsCount = 0;
        for (int index = 0; index < length; ++index) {
            char character = message.charAt(index);
            if (this.escape && character == '\'' && index + 1 < length && openingCurlyBracketsCount == 0) {
                if (message.charAt(index + 1) == '\'') {
                    builder.append('\'');
                    ++index;
                    continue;
                }
                openingTickIndex = openingTickIndex < 0 ? builder.length() : -1;
                continue;
            }
            if (character == '{' && index + 1 < length && arguments.hasNext() && openingTickIndex < 0) {
                if (openingCurlyBracketsCount++ == 0) {
                    openingCurlyBracketIndex = builder.length();
                    continue;
                }
                builder.append(character);
                continue;
            }
            if (character == '}' && openingCurlyBracketsCount > 0 && openingTickIndex < 0) {
                if (--openingCurlyBracketsCount == 0) {
                    Object argument = AdvancedMessageFormatter.resolve(arguments.next());
                    if (openingCurlyBracketIndex == builder.length()) {
                        builder.append(argument);
                        continue;
                    }
                    String pattern = builder.substring(openingCurlyBracketIndex);
                    builder.setLength(openingCurlyBracketIndex);
                    builder.append(this.format(pattern, argument));
                    continue;
                }
                builder.append(character);
                continue;
            }
            builder.append(character);
        }
        if (openingCurlyBracketsCount > 0) {
            builder.insert(openingCurlyBracketIndex, '{');
        }
        if (openingTickIndex >= 0) {
            builder.insert(openingTickIndex, '\'');
        }
        return builder.toString();
    }

    private String format(String pattern, Object argument) {
        try {
            return this.getFormatter(pattern, argument).format(argument);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.WARN, "Illegal argument '" + argument + "' for pattern '" + pattern + "'");
            return String.valueOf(argument);
        }
    }

    private Format getFormatter(String pattern, Object argument) {
        if (pattern.indexOf(124) != -1) {
            int start = pattern.indexOf(123);
            if (start >= 0 && start < pattern.lastIndexOf(125)) {
                return new ChoiceFormat(this.format(pattern, new EndlessIterator<Object>(argument)));
            }
            return new ChoiceFormat(pattern);
        }
        return new DecimalFormat(pattern, this.symbols);
    }
}

