/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.registrar.tree;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.registrar.tree.CommandCompletionProvider;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.registry.DefaultedRegistryReference;

public interface CommandTreeNode<T extends CommandTreeNode<T>> {
    public static CommandTreeNode<Root> root() {
        return Sponge.game().factoryProvider().provide(NodeFactory.class).createRoot();
    }

    public static CommandTreeNode<Basic> literal() {
        return Sponge.game().factoryProvider().provide(NodeFactory.class).createLiteral();
    }

    public T child(String var1, Argument<@NonNull ?> var2);

    default public <C extends Argument<C>> T child(String key, DefaultedRegistryReference<CommandTreeNodeType<C>> type, Consumer<C> processor) {
        return this.child(key, Objects.requireNonNull(type, "type").get(), processor);
    }

    default public <C extends Argument<C>> T child(String key, CommandTreeNodeType<C> type, Consumer<C> processor) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(processor, "processor");
        Argument child = (Argument)type.createNode();
        processor.accept(child);
        return this.child(key, child);
    }

    public T redirect(CommandTreeNode<@NonNull ?> var1);

    public T requires(@Nullable Predicate<CommandCause> var1);

    public T executable();

    default public T completions(@Nullable DefaultedRegistryReference<CommandCompletionProvider> completionProvider) {
        if (completionProvider == null) {
            return this.completions((CommandCompletionProvider)null);
        }
        return this.completions(completionProvider.get());
    }

    public T completions(@Nullable CommandCompletionProvider var1);

    public T customCompletions();

    public static interface NodeFactory {
        public CommandTreeNode<Root> createRoot();

        public CommandTreeNode<Basic> createLiteral();
    }

    public static interface Argument<T extends CommandTreeNode<T>>
    extends CommandTreeNode<T> {
    }

    public static interface StringParser
    extends Argument<StringParser> {
        public StringParser word();

        public StringParser greedy();
    }

    public static interface EntitySelection
    extends Argument<EntitySelection> {
        public EntitySelection playersOnly();

        public EntitySelection single();
    }

    public static interface Amount
    extends Argument<Amount> {
        public Amount single();
    }

    public static interface Range<S extends Number>
    extends Argument<Range<S>> {
        public Range<S> min(@Nullable S var1);

        public Range<S> max(@Nullable S var1);
    }

    public static interface Basic
    extends Argument<Basic> {
    }

    public static interface Root
    extends CommandTreeNode<Root> {
    }
}

