/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.ImmutableDataProviderBuilder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.MutableDataProviderBuilder;
import org.spongepowered.api.data.value.Value;

public interface DataProvider<V extends Value<E>, E> {
    public static <H extends DataHolder.Mutable, V extends Value<E>, E> MutableDataProviderBuilder<H, V, E> mutableBuilder() {
        return Sponge.game().builderProvider().provide(MutableDataProviderBuilder.class);
    }

    public static <H extends DataHolder, V extends Value<E>, E> ImmutableDataProviderBuilder<H, V, E> immutableBuilder() {
        return Sponge.game().builderProvider().provide(ImmutableDataProviderBuilder.class);
    }

    public Key<V> key();

    public boolean allowsAsynchronousAccess(DataHolder var1);

    public Optional<E> get(DataHolder var1);

    default public Optional<V> value(DataHolder dataHolder) {
        return this.get(dataHolder).map(element -> Value.genericMutableOf(this.key(), element));
    }

    public boolean isSupported(DataHolder var1);

    default public boolean isSupported(TypeToken<? extends DataHolder> dataHolder) {
        return this.isSupported(dataHolder.getType());
    }

    public boolean isSupported(Type var1);

    public DataTransactionResult offer(DataHolder.Mutable var1, E var2);

    default public DataTransactionResult offerValue(DataHolder.Mutable dataHolder, V value) {
        return this.offer(dataHolder, value.get());
    }

    public DataTransactionResult remove(DataHolder.Mutable var1);

    public <I extends DataHolder.Immutable<I>> Optional<I> with(I var1, E var2);

    default public <I extends DataHolder.Immutable<I>> Optional<I> withValue(I immutable, V value) {
        return this.with(immutable, value.get());
    }

    public <I extends DataHolder.Immutable<I>> Optional<I> without(I var1);
}

