/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.effect;

import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface Viewer
extends Audience {
    public void sendWorldType(WorldType var1);

    default public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        this.spawnParticles(Objects.requireNonNull(particleEffect, "particleEffect"), Objects.requireNonNull(position, "position"), Integer.MAX_VALUE);
    }

    public void spawnParticles(ParticleEffect var1, Vector3d var2, int var3);

    default public void playSound(@NonNull Sound sound, Vector3d pos) {
        this.playSound(sound, pos.x(), pos.y(), pos.z());
    }

    public void playMusicDisc(Vector3i var1, MusicDisc var2);

    public void stopMusicDisc(Vector3i var1);

    default public void sendBlockChange(Vector3i position, BlockState state) {
        Objects.requireNonNull(position, "position");
        this.sendBlockChange(position.x(), position.y(), position.z(), Objects.requireNonNull(state, "state"));
    }

    public void sendBlockChange(int var1, int var2, int var3, BlockState var4);

    default public void resetBlockChange(Vector3i position) {
        Objects.requireNonNull(position, "position");
        this.resetBlockChange(position.x(), position.y(), position.z());
    }

    public void resetBlockChange(int var1, int var2, int var3);
}

