/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.projectile.source.EntityProjectileSource;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.util.RelativePositions;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.vector.Vector3d;

@DoNotStore
public interface Entity
extends Identifiable,
HoverEventSource<HoverEvent.ShowEntity>,
Locatable,
EntityProjectileSource,
Sound.Emitter,
SerializableDataHolder.Mutable,
RandomProvider {
    public EntityType<?> type();

    public EntitySnapshot createSnapshot();

    @Override
    public Entity copy();

    public EntityArchetype createArchetype();

    public Vector3d position();

    public boolean setPosition(Vector3d var1);

    public boolean setLocation(ServerLocation var1);

    public Vector3d rotation();

    public void setRotation(Vector3d var1);

    default public Vector3d direction() {
        Vector3d rotation = this.rotation();
        return Quaterniond.fromAxesAnglesDeg((double)rotation.x(), (double)(-rotation.y()), (double)rotation.z()).direction();
    }

    public boolean setLocationAndRotation(ServerLocation var1, Vector3d var2);

    public boolean setLocationAndRotation(ServerLocation var1, Vector3d var2, EnumSet<RelativePositions> var3);

    public Vector3d scale();

    public void setScale(Vector3d var1);

    public Transform transform();

    public boolean setTransform(Transform var1);

    default public boolean transferToWorld(ServerWorld world) {
        Objects.requireNonNull(world, "World cannot be null");
        return this.transferToWorld(world, world.properties().spawnPosition().toDouble());
    }

    public boolean transferToWorld(ServerWorld var1, Vector3d var2);

    public Optional<AABB> boundingBox();

    public boolean isRemoved();

    public boolean isLoaded();

    public void remove();

    default public boolean damage(double damage, Supplier<? extends DamageSource> damageSource) {
        return this.damage(damage, damageSource.get());
    }

    public boolean damage(double var1, DamageSource var3);

    default public Collection<? extends Entity> nearbyEntities(double distance) {
        if (distance <= 0.0) {
            throw new IllegalArgumentException("Distance must be greater than 0!");
        }
        return this.world().nearbyEntities(this.location().position(), distance);
    }

    default public Collection<? extends Entity> nearbyEntities(double distance, Predicate<? super Entity> predicate) {
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        return this.world().entities(this.boundingBox().get().expand(distance, distance, distance), predicate);
    }

    default public boolean canSee(Entity entity) {
        Objects.requireNonNull(entity, "Entity cannot be null");
        Optional optional = entity.get(Keys.VANISH_STATE);
        return optional.map(VanishState::invisible).orElse(false) == false;
    }

    public void lookAt(Vector3d var1);

    default public Value.Mutable<Component> displayName() {
        return this.requireValue(Keys.DISPLAY_NAME).asMutable();
    }

    default public Value.Mutable<Double> fallDistance() {
        return this.requireValue(Keys.FALL_DISTANCE).asMutable();
    }

    default public ListValue.Mutable<Entity> passengers() {
        return ((ListValue)this.requireValue(Keys.PASSENGERS)).asMutable();
    }

    default public Optional<Value.Mutable<Entity>> vehicle() {
        return this.getValue(Keys.VEHICLE).map(Value::asMutable);
    }

    default public Optional<Value<Entity>> baseVehicle() {
        return this.getValue(Keys.BASE_VEHICLE).map(Value::asMutable);
    }

    default public Value<Boolean> onGround() {
        return this.requireValue(Keys.ON_GROUND).asMutable();
    }

    default public Value.Mutable<Vector3d> velocity() {
        return this.requireValue(Keys.VELOCITY).asMutable();
    }

    default public Value.Mutable<Boolean> gravityAffected() {
        return this.requireValue(Keys.IS_GRAVITY_AFFECTED).asMutable();
    }

    default public Value.Mutable<Boolean> silent() {
        return this.requireValue(Keys.IS_SILENT).asMutable();
    }

    default public Optional<Value.Mutable<UUID>> creator() {
        return this.getValue(Keys.CREATOR).map(Value::asMutable);
    }

    default public Optional<Value.Mutable<UUID>> notifier() {
        return this.getValue(Keys.NOTIFIER).map(Value::asMutable);
    }

    default public Optional<Value.Mutable<Ticks>> fireTicks() {
        return this.getValue(Keys.FIRE_TICKS).map(Value::asMutable);
    }

    default public Value.Mutable<Ticks> fireImmuneTicks() {
        return this.requireValue(Keys.FIRE_DAMAGE_DELAY).asMutable();
    }

    default public Value.Mutable<Boolean> isTransient() {
        return this.requireValue(Keys.TRANSIENT).asMutable();
    }

    default public Value.Mutable<Integer> age() {
        return this.requireValue(Keys.AGE).asMutable();
    }

    default public Value<Double> baseSize() {
        return this.requireValue(Keys.BASE_SIZE);
    }

    default public Value<Double> eyeHeight() {
        return this.requireValue(Keys.EYE_HEIGHT);
    }

    default public Value<Vector3d> eyePosition() {
        return this.requireValue(Keys.EYE_POSITION);
    }

    default public Value<Double> height() {
        return this.requireValue(Keys.HEIGHT);
    }

    default public Value.Mutable<Ticks> invulnerabilityTicks() {
        return this.requireValue(Keys.INVULNERABILITY_TICKS).asMutable();
    }

    default public Value.Mutable<Boolean> customNameVisible() {
        return this.requireValue(Keys.IS_CUSTOM_NAME_VISIBLE).asMutable();
    }

    default public Value.Mutable<Boolean> glowing() {
        return this.requireValue(Keys.IS_GLOWING).asMutable();
    }

    default public Value.Mutable<Boolean> invisible() {
        return this.requireValue(Keys.IS_INVISIBLE).asMutable();
    }

    default public Value.Mutable<Boolean> invulnerable() {
        return this.requireValue(Keys.INVULNERABLE).asMutable();
    }

    default public Value.Mutable<Boolean> sneaking() {
        return this.requireValue(Keys.IS_SNEAKING).asMutable();
    }

    default public Value.Mutable<Boolean> sprinting() {
        return this.requireValue(Keys.IS_SPRINTING).asMutable();
    }

    default public Value<Boolean> wet() {
        return this.requireValue(Keys.IS_WET).asMutable();
    }

    default public Value.Mutable<Integer> maxAir() {
        return this.requireValue(Keys.MAX_AIR).asMutable();
    }

    default public Value.Mutable<Integer> remainingAir() {
        return this.requireValue(Keys.REMAINING_AIR).asMutable();
    }

    default public SetValue.Mutable<String> scoreboardTags() {
        return ((SetValue)this.requireValue(Keys.SCOREBOARD_TAGS)).asMutable();
    }

    default public Value.Mutable<VanishState> vanishState() {
        return this.requireValue(Keys.VANISH_STATE).asMutable();
    }

    default public Value.Mutable<Boolean> vanish() {
        return this.requireValue(Keys.VANISH).asMutable();
    }

    default public Value.Mutable<Boolean> vanishIgnoresCollision() {
        return this.requireValue(Keys.VANISH_IGNORES_COLLISION).asMutable();
    }

    default public Value.Mutable<Boolean> vanishPreventsTargeting() {
        return this.requireValue(Keys.VANISH_PREVENTS_TARGETING).asMutable();
    }

    default public Optional<Value.Mutable<Component>> customName() {
        return this.getValue(Keys.CUSTOM_NAME).map(Value::asMutable);
    }

    default public Optional<Value.Mutable<Double>> swiftness() {
        return this.getValue(Keys.SWIFTNESS).map(Value::asMutable);
    }

    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(UnaryOperator<HoverEvent.ShowEntity> var1);
}

