/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity.living.player.server;

import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.PlayerChatFormatter;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.chat.ChatVisibility;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.server.ServerWorld;

public interface ServerPlayer
extends Player,
Subject {
    public ServerWorld world();

    public User user();

    public boolean isOnline();

    default public boolean isViewingInventory() {
        return this.openInventory().isPresent();
    }

    public Optional<Container> openInventory();

    public Optional<Container> openInventory(Inventory var1) throws IllegalArgumentException;

    public Optional<Container> openInventory(Inventory var1, Component var2);

    public boolean closeInventory() throws IllegalArgumentException;

    default public Value.Mutable<Integer> viewDistance() {
        return this.requireValue(Keys.VIEW_DISTANCE).asMutable();
    }

    default public Value.Mutable<ChatVisibility> chatVisibility() {
        return this.requireValue(Keys.CHAT_VISIBILITY).asMutable();
    }

    default public Value.Mutable<Boolean> chatColorsEnabled() {
        return this.requireValue(Keys.CHAT_COLORS_ENABLED).asMutable();
    }

    public PlayerChatEvent simulateChat(Component var1, Cause var2);

    default public SetValue.Mutable<SkinPart> displayedSkinParts() {
        return ((SetValue)this.requireValue(Keys.SKIN_PARTS)).asMutable();
    }

    public ServerPlayerConnection connection();

    public void sendResourcePack(ResourcePack var1);

    public TabList tabList();

    public boolean kick();

    public boolean kick(Component var1);

    public Scoreboard scoreboard();

    public void setScoreboard(Scoreboard var1);

    public boolean respawn();

    public Optional<WorldBorder> worldBorder();

    public Optional<WorldBorder> setWorldBorder(@Nullable WorldBorder var1);

    public CooldownTracker cooldownTracker();

    public AdvancementProgress progress(Advancement var1);

    public Collection<AdvancementTree> unlockedAdvancementTrees();

    default public Value.Mutable<Boolean> hasViewedCredits() {
        return this.requireValue(Keys.HAS_VIEWED_CREDITS).asMutable();
    }

    default public boolean hasPlayedBefore() {
        return !this.firstJoined().equals(this.lastPlayed());
    }

    default public Value.Mutable<Entity> spectatorTarget() {
        return this.requireValue(Keys.SPECTATOR_TARGET).asMutable();
    }

    public PlayerChatFormatter chatFormatter();

    public void setChatFormatter(PlayerChatFormatter var1);

    default public Value.Mutable<GameMode> gameMode() {
        return this.requireValue(Keys.GAME_MODE).asMutable();
    }

    default public MapValue.Mutable<Statistic, Long> statistics() {
        return ((MapValue)this.requireValue(Keys.STATISTICS)).asMutable();
    }

    default public Optional<Value.Mutable<Double>> healthScale() {
        return this.getValue(Keys.HEALTH_SCALE).map(Value::asMutable);
    }

    default public Optional<Value.Mutable<Instant>> firstJoined() {
        return this.getValue(Keys.FIRST_DATE_JOINED).map(Value::asMutable);
    }

    default public Optional<Value.Mutable<Instant>> lastJoined() {
        return this.getValue(Keys.LAST_DATE_JOINED).map(Value::asMutable);
    }

    default public Optional<Value.Mutable<Instant>> lastPlayed() {
        return this.getValue(Keys.LAST_DATE_PLAYED).map(Value::asMutable);
    }
}

