/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.scheduler;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.scheduler.TaskPriorities;
import org.spongepowered.api.scheduler.TaskPriority;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.math.vector.Vector3i;

public interface ScheduledUpdateList<T> {
    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, int delay, TemporalUnit temporalUnit) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, delay, temporalUnit, TaskPriorities.NORMAL.get());
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Duration delay) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, delay, TaskPriorities.NORMAL);
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, int delay, TemporalUnit temporalUnit) {
        return this.schedule(x, y, z, target, delay, temporalUnit, TaskPriorities.NORMAL.get());
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Duration delay) {
        return this.schedule(x, y, z, target, delay, TaskPriorities.NORMAL);
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, Duration.of(delay, temporalUnit), priority);
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, int delay, TemporalUnit temporalUnit, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, Duration.of(delay, temporalUnit), priority.get());
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Duration delay, TaskPriority priority) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, delay, priority);
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Duration delay, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, delay, priority.get());
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        return this.schedule(x, y, z, target, Duration.of(delay, temporalUnit), priority);
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, int delay, TemporalUnit temporalUnit, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(x, y, z, target, Duration.of(delay, temporalUnit), priority.get());
    }

    public ScheduledUpdate<T> schedule(int var1, int var2, int var3, T var4, Duration var5, TaskPriority var6);

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Ticks ticks, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(x, y, z, target, ticks, priority.get());
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Ticks delay) {
        return this.schedule(x, y, z, target, delay, TaskPriorities.NORMAL.get());
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Ticks delay) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, delay, TaskPriorities.NORMAL.get());
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Ticks delay, TaskPriority priority) {
        return this.schedule(pos.x(), pos.y(), pos.z(), target, delay, priority);
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Duration delay, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(x, y, z, target, delay, priority.get());
    }

    public ScheduledUpdate<T> schedule(int var1, int var2, int var3, T var4, Ticks var5, TaskPriority var6);

    default public boolean isScheduled(Vector3i pos, T target) {
        return this.isScheduled(pos.x(), pos.y(), pos.z(), target);
    }

    public boolean isScheduled(int var1, int var2, int var3, T var4);

    default public Collection<? extends ScheduledUpdate<T>> scheduledAt(Vector3i pos) {
        return this.scheduledAt(pos.x(), pos.y(), pos.z());
    }

    public Collection<? extends ScheduledUpdate<T>> scheduledAt(int var1, int var2, int var3);
}

