/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Objects;
import org.spongepowered.api.Engine;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.api.world.volume.block.entity.BlockEntityVolume;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.api.world.volume.game.GenerationVolume;
import org.spongepowered.api.world.volume.game.LocationBaseDataHolder;
import org.spongepowered.api.world.volume.game.MutableGameVolume;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.game.UpdatableVolume;
import org.spongepowered.math.vector.Vector3i;

public interface WorldLike<P extends WorldLike<P>>
extends Region<P>,
BiomeVolume.Modifiable<P>,
BlockVolume.Modifiable<P>,
EntityVolume.Modifiable<P>,
BlockEntityVolume.Modifiable<P>,
GenerationVolume.Mutable,
LocationBaseDataHolder.Mutable,
UpdatableVolume,
RandomProvider,
PhysicsAwareMutableBlockVolume<P>,
MutableGameVolume {
    public Engine engine();

    public long seed();

    public Difficulty difficulty();

    @Override
    default public boolean setBlock(Vector3i position, BlockState state, BlockChangeFlag flag) {
        Objects.requireNonNull(position, "position");
        return this.setBlock(position.x(), position.y(), position.z(), Objects.requireNonNull(state, "state"), Objects.requireNonNull(flag, "flag"));
    }

    @Override
    public boolean setBlock(int var1, int var2, int var3, BlockState var4, BlockChangeFlag var5);

    @Override
    default public boolean removeBlock(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.removeBlock(position.x(), position.y(), position.z());
    }

    @Override
    public boolean removeBlock(int var1, int var2, int var3);
}

