/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.archetype;

import java.util.Objects;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.volume.archetype.block.entity.BlockEntityArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeVolume;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollectors;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface ArchetypeVolume
extends BlockVolume.Modifiable<ArchetypeVolume>,
BlockEntityArchetypeVolume.Modifiable<ArchetypeVolume>,
EntityArchetypeVolume.Modifiable<ArchetypeVolume>,
BiomeVolume.Modifiable<ArchetypeVolume> {
    public ArchetypeVolume transform(Transformation var1);

    default public Vector3d logicalCenter() {
        return this.min().toDouble().add(this.size().toDouble().div(2.0f));
    }

    default public void applyToWorld(ServerWorld target, Vector3i placement, Supplier<SpawnType> spawnContext) {
        Objects.requireNonNull(target, "Target world cannot be null");
        Objects.requireNonNull(placement, "Target position cannot be null");
        try (CauseStackManager.StackFrame frame = Sponge.server().causeStackManager().pushCauseFrame();){
            this.blockStateStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyBlocks(BlockChangeFlags.DEFAULT_PLACEMENT)));
            this.biomeStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyBiomes()));
            this.blockEntityArchetypeStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyBlockEntityArchetype()));
            frame.addContext(EventContextKeys.SPAWN_TYPE, spawnContext);
            this.entityArchetypeStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyEntityArchetype()));
        }
    }
}

