/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.util.Objects;
import java.util.function.Supplier;
import org.spongepowered.api.world.LightType;
import org.spongepowered.api.world.LightTypes;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.game.PrimitiveGameVolume;
import org.spongepowered.math.vector.Vector3i;

public interface EnvironmentalVolume
extends PrimitiveGameVolume,
BiomeVolume {
    public int light(LightType var1, int var2, int var3, int var4);

    default public int light(Supplier<? extends LightType> type, int x, int y, int z) {
        Objects.requireNonNull(type);
        return this.light(type.get(), x, y, z);
    }

    default public int light(LightType type, Vector3i position) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(position);
        return this.light(type, position.x(), position.y(), position.z());
    }

    default public int light(Supplier<? extends LightType> type, Vector3i position) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(position);
        return this.light(type.get(), position.x(), position.y(), position.z());
    }

    default public int light(int x, int y, int z) {
        return this.light(LightTypes.BLOCK, x, y, z);
    }

    default public int light(Vector3i position) {
        Objects.requireNonNull(position);
        return this.light(position.x(), position.y(), position.z());
    }

    default public boolean isSkylightMax(Vector3i position) {
        Objects.requireNonNull(position);
        return this.light(LightTypes.SKY, position) >= this.maximumLight();
    }
}

