/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.potion.PotionType;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class PotionItemStackData {
    private PotionItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.COLOR).get(h -> Color.ofRgb(PotionUtils.getColor((ItemStack)h)))).set((h, v) -> {
            CompoundTag tag = h.getOrCreateTag();
            tag.putInt("CustomPotionColor", v.rgb());
        })).delete(h -> h.removeTagKey("CustomPotionColor"))).supports(h -> h.getItem() == Items.POTION || h.getItem() == Items.SPLASH_POTION || h.getItem() == Items.LINGERING_POTION)).create(Keys.POTION_EFFECTS).get(h -> {
            List effects = PotionUtils.getMobEffects((ItemStack)h);
            return effects.isEmpty() ? null : ImmutableList.copyOf((Collection)effects);
        })).set((h, v) -> {
            CompoundTag tag = h.getOrCreateTag();
            ListTag list = v.stream().map(effect -> {
                CompoundTag potionTag = new CompoundTag();
                ((MobEffectInstance)effect).save(potionTag);
                return potionTag;
            }).collect(NBTCollectors.toTagList());
            tag.put("CustomPotionEffects", (Tag)list);
        })).delete(h -> h.removeTagKey("CustomPotionEffects"))).supports(h -> h.getItem() == Items.POTION || h.getItem() == Items.SPLASH_POTION || h.getItem() == Items.LINGERING_POTION || h.getItem() == Items.TIPPED_ARROW)).create(Keys.POTION_TYPE).get(h -> (PotionType)PotionUtils.getPotion((ItemStack)h))).set((h, v) -> {
            h.getOrCreateTag();
            PotionUtils.setPotion((ItemStack)h, (Potion)((Potion)v));
        })).delete(h -> {
            if (h.hasTag()) {
                PotionUtils.setPotion((ItemStack)h, (Potion)Potions.EMPTY);
            }
        })).supports(h -> h.getItem() == Items.POTION || h.getItem() == Items.SPLASH_POTION || h.getItem() == Items.LINGERING_POTION || h.getItem() == Items.TIPPED_ARROW);
    }
}

